/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.fastnate.data.DataImportException;
import org.fastnate.data.EntityRegistration;
import org.fastnate.data.csv.properties.DataRow;
import org.fastnate.data.files.DataFile;
import org.fastnate.data.properties.PluralPropertyContents;
import org.fastnate.data.properties.PropertyConverter;
import org.fastnate.data.properties.PropertyDataImporter;
import org.fastnate.generator.context.EmbeddedProperty;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.EntityProperty;
import org.fastnate.generator.context.GeneratedIdProperty;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.MapProperty;
import org.fastnate.generator.context.PluralProperty;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.context.SingularProperty;
import org.supercsv.comment.CommentMatcher;
import org.supercsv.comment.CommentMatches;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public class CsvDataImporter<E>
extends PropertyDataImporter {
    public static final String COLUMN_DELIMITER = "fastnate.csv.delimiter.column";
    public static final String LINE_DELIMITER = "fastnate.csv.delimiter.line";
    public static final String COLLECTION_DELIMITER = "fastnate.csv.delimiter.collection";
    public static final String MAP_DELIMITER = "fastnate.csv.delimiter.map";
    private final EntityClass<E> entityClass;
    private final EntityRegistration entityRegistration;
    private CsvPreference csvSettings;
    private String collectionDelimiter;
    private String mapDelimiter;
    private final Map<String, BiConsumer<E, String>> columnMapping = new HashMap<String, BiConsumer<E, String>>();
    private boolean ignoreMissingColumns;
    private boolean ignoreUnknownColumns;
    private final Set<String> ignoredColumns = new HashSet<String>();
    private final List<BiConsumer<DataRow, E>> postProcessors = new ArrayList<BiConsumer<DataRow, E>>();

    private static <V, T> BiConsumer<T, V> buildInverseMapping(Property<V, ?> inverseProperty) {
        if (inverseProperty instanceof PluralProperty) {
            return (entity, targetEntity) -> PluralPropertyContents.create((Object)targetEntity, (PluralProperty)((PluralProperty)inverseProperty)).addElement(entity);
        }
        if (inverseProperty instanceof EntityProperty) {
            return (entity, targetEntity) -> ((EntityProperty)inverseProperty).setValue(targetEntity, entity);
        }
        return (entity, targetEntity) -> {};
    }

    private static boolean isNotEmpty(List<String> values) {
        return values.size() > 1 || values.size() == 1 && StringUtils.isNotBlank((CharSequence)values.get(0));
    }

    private static void lowerCaseHeader(String[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            if (column == null) continue;
            columns[i] = column.toLowerCase();
        }
    }

    private static <T, V> Consumer<V> wrapInverseMapping(BiConsumer<T, V> inverseMapping, T entity) {
        return value -> inverseMapping.accept(entity, value);
    }

    public CsvDataImporter(Class<E> entityClass) {
        this(new GeneratorContext().getDescription(entityClass));
    }

    public CsvDataImporter(EntityClass<E> entityClass) {
        this(entityClass, new EntityRegistration(entityClass.getContext()));
    }

    public CsvDataImporter(EntityClass<E> entityClass, CsvPreference csvSettings) {
        this(entityClass, csvSettings, new EntityRegistration(entityClass.getContext()));
    }

    public CsvDataImporter(EntityClass<E> entityClass, CsvPreference csvSettings, EntityRegistration entityRegistration) {
        this.entityClass = entityClass;
        this.csvSettings = csvSettings;
        this.entityRegistration = entityRegistration;
        this.collectionDelimiter = entityClass.getContext().getSettings().getProperty(COLLECTION_DELIMITER, ",");
        this.mapDelimiter = entityClass.getContext().getSettings().getProperty(MAP_DELIMITER, ":");
    }

    public CsvDataImporter(EntityClass<E> entityClass, EntityRegistration entityRegistration) {
        this(entityClass, new CsvPreference.Builder('\"', (int)entityClass.getContext().getSettings().getProperty(COLUMN_DELIMITER, ",").charAt(0), entityClass.getContext().getSettings().getProperty(LINE_DELIMITER, "\n")).skipComments((CommentMatcher)new CommentMatches("(//|#).*")).build(), entityRegistration);
    }

    public void addColumnMapping(String column, BiConsumer<E, String> propertyMapping) {
        this.columnMapping.put(column.toLowerCase(), propertyMapping);
    }

    public <T> void addColumnMapping(String column, Class<T> propertyClass, PropertyConverter<T> converter, BiConsumer<E, T> propertyMapping) {
        this.columnMapping.put(column.toLowerCase(), (entity, columnValue) -> propertyMapping.accept(entity, converter.convert(propertyClass, columnValue)));
    }

    public <T> void addColumnMapping(String column, Function<String, T> converter, BiConsumer<E, T> propertyMapping) {
        this.columnMapping.put(column.toLowerCase(), (entity, columnValue) -> propertyMapping.accept(entity, converter.apply((String)columnValue)));
    }

    public void addDefaultColumnMapping(String columnName) {
        this.addDefaultColumnMapping(columnName, columnName);
    }

    public void addDefaultColumnMapping(String columnName, String propertyName) {
        Property property = (Property)this.entityClass.getProperties().get(propertyName);
        if (property == null) {
            throw new IllegalArgumentException("Can't find property \"" + propertyName + '\"');
        }
        BiConsumer mapping = this.buildMapping(property);
        if (mapping == null) {
            throw new IllegalArgumentException("Can't handle property \"" + propertyName + '\"');
        }
        this.columnMapping.put(columnName.toLowerCase(), mapping);
    }

    public void addIgnoredColumn(String column) {
        this.ignoredColumns.add(column.toLowerCase());
    }

    public void addPostProcessor(Consumer<E> postProcessor) {
        this.postProcessors.add((row, entity) -> postProcessor.accept(entity));
    }

    protected boolean applyColumn(E entity, String column, String value) {
        if (this.ignoredColumns.contains(column)) {
            return false;
        }
        BiConsumer<E, String> mapper = this.columnMapping.get(column);
        if (mapper != null) {
            try {
                mapper.accept(entity, value);
                return true;
            }
            catch (RuntimeException e) {
                if (e instanceof DataImportException) {
                    throw e;
                }
                throw new IllegalArgumentException("Could not map column \"" + column + "\": " + e, e);
            }
        }
        if (!this.ignoreUnknownColumns) {
            throw new IllegalArgumentException("Could not find column property for '" + column + "' in " + entity.getClass());
        }
        return false;
    }

    private <T> BiConsumer<E, String> buildEmbeddedMapping(EmbeddedProperty<? super E, T> embeddedProperty, Property<T, ?> childProperty) {
        BiConsumer mapping = this.buildMapping(childProperty);
        if (mapping == null) {
            return null;
        }
        return (entity, value) -> mapping.accept((Object)embeddedProperty.getInitializedValue(entity), (String)value);
    }

    private <V, U> BiConsumer<String, Consumer<V>> buildMapping(Class<V> valueClass, EntityClass<V> valueEntityClass) {
        PropertyConverter valueConverter = this.findConverter(valueClass);
        if (valueConverter != null) {
            return (value, consumer) -> consumer.accept(valueConverter.convert(valueClass, value));
        }
        if (valueEntityClass == null) {
            return null;
        }
        List singleUniqueProperties = valueEntityClass.getAllUniqueProperties().stream().filter(list -> list.size() == 1).collect(Collectors.toList());
        if (singleUniqueProperties.size() != 1) {
            return null;
        }
        SingularProperty uniqueProperty = (SingularProperty)((List)singleUniqueProperties.get(0)).get(0);
        EntityClass targetEntityClass = uniqueProperty instanceof EntityProperty ? ((EntityProperty)uniqueProperty).getTargetClass() : null;
        BiConsumer uniquePropertyMapping = this.buildMapping(uniqueProperty.getType(), targetEntityClass);
        if (uniquePropertyMapping == null) {
            return null;
        }
        return (value, entityConsumer) -> uniquePropertyMapping.accept((String)value, uniqueValue -> this.entityRegistration.invokeOnEntity(valueEntityClass.getEntityClass(), uniqueProperty.getName(), uniqueValue, entityConsumer));
    }

    protected <T, V> BiConsumer<T, String> buildMapping(Property<? super T, V> property) {
        if (property instanceof EntityProperty) {
            EntityProperty entityProperty = (EntityProperty)property;
            BiConsumer mapping = this.buildMapping(property.getType(), entityProperty.getTargetClass());
            BiConsumer inverseMapping = CsvDataImporter.buildInverseMapping(entityProperty.getInverseProperty());
            return (entity, value) -> {
                if (StringUtils.isNotEmpty((CharSequence)value)) {
                    mapping.accept((String)value, (Consumer)CsvDataImporter.wrapInverseMapping(inverseMapping, entity).andThen(valueObject -> property.setValue(entity, valueObject)));
                }
            };
        }
        Class type = property.getType();
        PropertyConverter converter = this.findConverter(type);
        if (converter == null) {
            if (property instanceof PluralProperty) {
                return this.buildPluralMapping((PluralProperty)property);
            }
            return null;
        }
        if (property instanceof GeneratedIdProperty) {
            String[] propertyNames = new String[]{property.getName()};
            return (entity, value) -> this.entityRegistration.registerEntity(entity, propertyNames, new Object[]{converter.convert(type, value)});
        }
        return (entity, value) -> property.setValue(entity, converter.convert(type, value));
    }

    private <T, K, V> BiConsumer<T, String> buildPluralMapping(PluralProperty<? super T, ?, V> property) {
        BiConsumer valueMapping;
        BiConsumer keyMapping;
        if (property.getEmbeddedProperties() != null) {
            return null;
        }
        if (property instanceof MapProperty) {
            MapProperty mapProperty = (MapProperty)property;
            keyMapping = this.buildMapping(mapProperty.getKeyClass(), mapProperty.getKeyEntityClass());
            if (keyMapping == null) {
                return null;
            }
        } else {
            keyMapping = null;
        }
        if ((valueMapping = this.buildMapping(property.getValueClass(), property.getValueEntityClass())) == null) {
            return null;
        }
        BiConsumer inverseMapping = CsvDataImporter.buildInverseMapping(property.getInverseProperty());
        return (entity, values) -> {
            if (StringUtils.isNotEmpty((CharSequence)values)) {
                PluralPropertyContents collection = PluralPropertyContents.create((Object)entity, (PluralProperty)property);
                String[] split = values.split(this.collectionDelimiter);
                for (int index = 0; index < split.length; ++index) {
                    String element = split[index].trim();
                    int currentIndex = index;
                    if (keyMapping != null) {
                        int delim = element.indexOf(this.mapDelimiter);
                        if (delim < 0) {
                            throw new DataImportException("Missing " + this.mapDelimiter + " in value of \"" + property.getName() + '\"');
                        }
                        String key = element.substring(0, delim).trim();
                        String value = element.substring(delim + 1).trim();
                        keyMapping.accept(key, keyObject -> valueMapping.accept(value, CsvDataImporter.wrapInverseMapping(inverseMapping, entity).andThen(valueObject -> collection.setElement(currentIndex, keyObject, valueObject))));
                        continue;
                    }
                    valueMapping.accept(element, CsvDataImporter.wrapInverseMapping(inverseMapping, entity).andThen(valueObject -> collection.setElement(currentIndex, null, valueObject)));
                }
            }
        };
    }

    private void checkForMissingColumns(DataFile file, String[] header) {
        HashSet<String> headers = new HashSet<String>(Arrays.asList(header));
        for (String column : this.columnMapping.keySet()) {
            if (headers.contains(column)) continue;
            throw new DataImportException("Missing column: " + column, file.getName(), 0);
        }
    }

    protected List<? extends E> createEntities(DataRow row) {
        return Collections.singletonList(this.createEntity(row));
    }

    protected E createEntity() {
        return (E)this.entityClass.newInstance();
    }

    protected E createEntity(DataRow row) {
        E entity = this.createEntity();
        for (int i = 0; i < row.getColumnCount(); ++i) {
            this.applyColumn(entity, row.getName(i), row.getValue(i));
        }
        return entity;
    }

    protected Charset getDefaultEncoding() {
        return StandardCharsets.UTF_8;
    }

    public List<E> importFile(DataFile file) throws IOException, DataImportException {
        try (CsvListReader csvList = this.openCsvListReader(file);){
            String[] header = csvList.getHeader(true);
            if (header != null && header.length > 0) {
                List values;
                CsvDataImporter.lowerCaseHeader(header);
                if (!this.ignoreMissingColumns) {
                    this.checkForMissingColumns(file, header);
                }
                ArrayList<E> entities = new ArrayList<E>();
                CsvDataRow row = new CsvDataRow(header);
                int rowIndex = 1;
                while ((values = csvList.read()) != null) {
                    if (CsvDataImporter.isNotEmpty(values)) {
                        row.setRow(values);
                        try {
                            List<E> newEntities = this.createEntities(row);
                            for (E entity : newEntities) {
                                entities.add(entity);
                                this.entityRegistration.registerEntity(entity);
                                for (BiConsumer<DataRow, E> postProcessor : this.postProcessors) {
                                    postProcessor.accept(row, entity);
                                }
                            }
                        }
                        catch (RuntimeException e) {
                            if (e instanceof DataImportException) {
                                throw e;
                            }
                            throw new DataImportException(e.getMessage(), file.getName(), rowIndex, (Throwable)e);
                        }
                    }
                    ++rowIndex;
                }
                ArrayList<E> arrayList = entities;
                return arrayList;
            }
            List list = Collections.emptyList();
            return list;
        }
    }

    public boolean isIgnoredColumn(String column) {
        return this.ignoredColumns.contains(column.toLowerCase());
    }

    public void mapProperties() {
        for (Property property : this.entityClass.getAllProperties()) {
            if (property instanceof EmbeddedProperty) {
                EmbeddedProperty embeddedProperty = (EmbeddedProperty)property;
                for (Property childProperty : embeddedProperty.getEmbeddedProperties().values()) {
                    this.columnMapping.computeIfAbsent(embeddedProperty.getName().toLowerCase() + '.' + property.getName().toLowerCase(), propertyName -> this.buildEmbeddedMapping(embeddedProperty, childProperty));
                }
                continue;
            }
            if (property instanceof GeneratedIdProperty) continue;
            this.columnMapping.computeIfAbsent(property.getName().toLowerCase(), propertyName -> this.buildMapping(property));
        }
    }

    public void mapTableColumns() {
        for (Property property : this.entityClass.getAllProperties()) {
            GeneratorColumn column;
            SingularProperty singularProperty;
            if (!(property instanceof SingularProperty) || !(singularProperty = (SingularProperty)property).isTableColumn() || (column = singularProperty.getColumn()) == null) continue;
            this.columnMapping.computeIfAbsent(column.getName().toLowerCase(), columnName -> this.buildMapping((Property)singularProperty));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CsvListReader openCsvListReader(DataFile importFile) throws IOException {
        InputStream fileStream = importFile.open();
        CsvListReader reader = null;
        try {
            BOMInputStream inputStream;
            if (importFile.getName().toLowerCase().endsWith(".gz")) {
                fileStream = new GZIPInputStream(fileStream);
            }
            String charset = (inputStream = new BOMInputStream(fileStream, false, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE})).hasBOM() ? inputStream.getBOMCharsetName() : this.getDefaultEncoding().toString();
            CsvListReader csvListReader = reader = new CsvListReader((Reader)new InputStreamReader((InputStream)inputStream, charset), this.csvSettings);
            return csvListReader;
        }
        finally {
            if (reader == null) {
                fileStream.close();
            }
        }
    }

    public BiConsumer<E, String> removeColumnMapping(String column) {
        return this.columnMapping.remove(column.toLowerCase());
    }

    public void removeIgnoredColumn(String column) {
        this.ignoredColumns.remove(column.toLowerCase());
    }

    @Generated
    public EntityClass<E> getEntityClass() {
        return this.entityClass;
    }

    @Generated
    public EntityRegistration getEntityRegistration() {
        return this.entityRegistration;
    }

    @Generated
    public CsvPreference getCsvSettings() {
        return this.csvSettings;
    }

    @Generated
    public String getCollectionDelimiter() {
        return this.collectionDelimiter;
    }

    @Generated
    public String getMapDelimiter() {
        return this.mapDelimiter;
    }

    @Generated
    public boolean isIgnoreMissingColumns() {
        return this.ignoreMissingColumns;
    }

    @Generated
    public boolean isIgnoreUnknownColumns() {
        return this.ignoreUnknownColumns;
    }

    @Generated
    public void setCsvSettings(CsvPreference csvSettings) {
        this.csvSettings = csvSettings;
    }

    @Generated
    public void setCollectionDelimiter(String collectionDelimiter) {
        this.collectionDelimiter = collectionDelimiter;
    }

    @Generated
    public void setMapDelimiter(String mapDelimiter) {
        this.mapDelimiter = mapDelimiter;
    }

    @Generated
    public void setIgnoreMissingColumns(boolean ignoreMissingColumns) {
        this.ignoreMissingColumns = ignoreMissingColumns;
    }

    @Generated
    public void setIgnoreUnknownColumns(boolean ignoreUnknownColumns) {
        this.ignoreUnknownColumns = ignoreUnknownColumns;
    }

    private static final class CsvDataRow
    extends DataRow {
        private List<String> row;

        CsvDataRow(String ... header) {
            super(Arrays.asList(header));
        }

        @Override
        public String getValue(int columnIndex) {
            if (columnIndex >= this.row.size()) {
                return "";
            }
            return this.row.get(columnIndex);
        }

        @Generated
        public List<String> getRow() {
            return this.row;
        }

        @Generated
        public void setRow(List<String> row) {
            this.row = row;
        }
    }
}

