/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.csv;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.fastnate.data.DataImportException;
import org.fastnate.data.csv.CsvDataImporter;
import org.fastnate.data.files.DataFile;
import org.fastnate.data.files.GenericDataProvider;
import org.fastnate.generator.context.EntityClass;

public class GenericCsvDataProvider
extends GenericDataProvider {
    private final Map<EntityClass<?>, CsvDataImporter<?>> importers = new HashMap();

    private <E> CsvDataImporter<E> createImporter(EntityClass<E> entityClass) {
        CsvDataImporter<E> importer = new CsvDataImporter<E>(entityClass, this.getEntityRegistration());
        importer.mapProperties();
        importer.setIgnoreMissingColumns(true);
        return importer;
    }

    protected Collection<?> importFile(DataFile importFile) throws DataImportException, IOException {
        EntityClass entityClass = this.findEntityClass(importFile);
        if (entityClass == null) {
            throw new DataImportException("Could not determine entity type for " + importFile, importFile.getName());
        }
        return this.importers.computeIfAbsent(entityClass, this::createImporter).importFile(importFile);
    }

    protected boolean isImportFile(DataFile file) {
        return file.getName().endsWith(".csv");
    }
}

