/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.csv.properties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DataRow {
    private final Map<String, Integer> headerMapping = new HashMap<String, Integer>();
    private final List<String> columnNames;

    public DataRow(List<String> columnNames) {
        this.columnNames = columnNames;
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            if (columnName == null) continue;
            this.headerMapping.put(columnName, i);
        }
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public String getName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnNames.size()) {
            return "";
        }
        String columnName = this.columnNames.get(columnIndex);
        return columnName == null ? "" : columnName;
    }

    public abstract String getValue(int var1);

    public String getValue(String columnName) {
        Integer columnIndex = this.headerMapping.get(columnName);
        if (columnIndex == null) {
            return "";
        }
        return this.getValue(columnIndex);
    }
}

