/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.fastnate.data.DataProvider;
import org.fastnate.generator.EntitySqlGenerator;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.ModelException;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityImporter {
    private static final Logger log = LoggerFactory.getLogger(EntityImporter.class);
    public static final String GENERATION_ABORTED_MESSAGE = "!!! GENERATION ABORTED !!!";
    public static final String DATA_FOLDER_KEY = "fastnate.data.folder";
    public static final String OUTPUT_FILE_KEY = "fastnate.data.sql.output.file";
    public static final String OUTPUT_ENCODING_KEY = "fastnate.data.sql.output.encoding";
    public static final String PREFIX_KEY = "fastnate.data.sql.prefix";
    public static final String POSTFIX_KEY = "fastnate.data.sql.postfix";
    public static final String PACKAGES_KEY = "fastnate.data.provider.packages";
    private final Properties settings;
    private final File dataFolder;
    private final GeneratorContext context;
    private final List<DataProvider> data = new ArrayList<DataProvider>();

    public static void main(String[] args) throws IOException {
        Properties settings = new Properties(System.getProperties());
        if (args.length > 0) {
            if (new File(args[0]).isDirectory()) {
                settings.put(DATA_FOLDER_KEY, args[0]);
                if (args.length > 1) {
                    settings.put(OUTPUT_FILE_KEY, args[1]);
                }
            } else {
                settings.put(OUTPUT_FILE_KEY, args[0]);
                if (args.length > 1) {
                    settings.put(DATA_FOLDER_KEY, args[1]);
                }
            }
        }
        new EntityImporter(settings).importData();
    }

    public EntityImporter() {
        this(new Properties());
    }

    public EntityImporter(Properties settings) {
        this(settings, new File(settings.getProperty(DATA_FOLDER_KEY, ".")), new GeneratorContext(settings));
    }

    public EntityImporter(Properties settings, File dataFolder, GeneratorContext context) {
        this.settings = settings;
        this.dataFolder = dataFolder;
        this.context = context;
        this.setup();
    }

    private DataProvider createProvider(Constructor<?> constructor) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] params = new Object[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            Class<?> parameterType = parameterTypes[i];
            if (parameterType == File.class) {
                params[i] = this.dataFolder;
            } else if (parameterType == Properties.class) {
                params[i] = this.settings;
            } else {
                DataProvider parameter = this.findProvider(parameterType);
                if (parameter == null) {
                    return null;
                }
                params[i] = parameter;
            }
            ++i;
        }
        try {
            return (DataProvider)constructor.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private DataProvider findProvider(Class<?> dataType) {
        for (DataProvider provider : this.data) {
            if (!dataType.isInstance(provider)) continue;
            return provider;
        }
        return null;
    }

    public void importData() throws IOException {
        this.importData(new File(this.settings.getProperty(OUTPUT_FILE_KEY, "data.sql")));
    }

    public void importData(File targetFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), Charset.forName(this.settings.getProperty(OUTPUT_ENCODING_KEY, "UTF-8"))));){
            this.importData(writer);
            log.info("'{}' generated.", (Object)targetFile.getAbsolutePath());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void importData(Writer writer) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (EntitySqlGenerator generator = new EntitySqlGenerator(writer, this.context);){
            try {
                log.info("Using {} for SQL generation.", (Object)this.context.getDialect().getClass().getSimpleName());
                for (DataProvider provider : this.data) {
                    provider.buildEntities();
                }
                generator.writeComment("Generated by FastNate EntityImporter for all found DataProvider instances.");
                this.writePropertyPart(generator, PREFIX_KEY);
                for (DataProvider provider : this.data) {
                    generator.getWriter().write("\n");
                    generator.writeComment("Data from " + provider.getClass().getSimpleName());
                    generator.write(provider.getEntities());
                    log.info("Generated SQL for {}", provider.getClass());
                }
                this.writePropertyPart(generator, POSTFIX_KEY);
            }
            catch (IOException | Error | RuntimeException e) {
                generator.getWriter().write("\n\n!!! GENERATION ABORTED !!!\n");
                e.printStackTrace(new PrintWriter(generator.getWriter(), true));
                throw e;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void setup() {
        log.info("Searching for implementations of " + DataProvider.class.getSimpleName());
        String packages = EntityImporter.class.getPackage() + ";" + this.settings.getProperty(PACKAGES_KEY, "").trim();
        Reflections reflections = new Reflections((Object[])packages.split("[\\s;,:]+"));
        ArrayList providers = new ArrayList(reflections.getSubTypesOf(DataProvider.class));
        Collections.sort(providers, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> c1, Class<?> c2) {
                return c1.getName().compareTo(c2.getName());
            }
        });
        while (!providers.isEmpty()) {
            int previousSize = providers.size();
            Iterator iterator = providers.iterator();
            block1: while (iterator.hasNext()) {
                Class providerClass = (Class)iterator.next();
                if (Modifier.isAbstract(providerClass.getModifiers())) {
                    iterator.remove();
                    continue;
                }
                Constructor<?>[] constructors = providerClass.getConstructors();
                ModelException.test((constructors.length > 0 ? 1 : 0) != 0, (String)("No public constructor found for " + providerClass));
                Constructor<?>[] constructorArray = constructors;
                int n = constructors.length;
                int n2 = 0;
                while (n2 < n) {
                    Constructor<?> constructor = constructorArray[n2];
                    DataProvider provider = this.createProvider(constructor);
                    if (provider != null) {
                        this.data.add(provider);
                        iterator.remove();
                        continue block1;
                    }
                    ++n2;
                }
            }
            ModelException.test((previousSize > providers.size() ? 1 : 0) != 0, (String)("No matching data provider in dependencies of " + Arrays.toString(providers.toArray())));
        }
    }

    private void writePropertyPart(EntitySqlGenerator generator, String property) throws IOException {
        String propertyValue = this.settings.getProperty(property);
        if (propertyValue != null) {
            block13: {
                generator.getWriter().write(10);
                File sqlFile = new File(propertyValue);
                if (sqlFile.isFile()) {
                    Throwable throwable = null;
                    Object var6_7 = null;
                    try (FileReader input = new FileReader(sqlFile);){
                        generator.writeComment(propertyValue);
                        IOUtils.copy((Reader)input, (Writer)generator.getWriter());
                        break block13;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                if (propertyValue.endsWith(".sql")) {
                    log.warn("Couldn't find file: " + propertyValue);
                    generator.writeComment("Couldn't find file: " + propertyValue);
                } else {
                    generator.writeComment(property);
                    generator.getWriter().write(propertyValue);
                }
            }
            generator.getWriter().write("\n");
        }
    }

    public Properties getSettings() {
        return this.settings;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    public List<DataProvider> getData() {
        return this.data;
    }
}

