/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.csv;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.fastnate.data.DataProvider;
import org.fastnate.data.csv.AbstractCsvReader;
import org.fastnate.data.csv.CsvBooleanConverter;
import org.fastnate.data.csv.CsvCharacterConverter;
import org.fastnate.data.csv.CsvDateConverter;
import org.fastnate.data.csv.CsvEnumConverter;
import org.fastnate.data.csv.CsvNumberConverter;
import org.fastnate.data.csv.CsvPropertyConverter;
import org.fastnate.data.util.ClassUtil;
import org.fastnate.generator.EntitySqlGenerator;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.context.SingularProperty;

public abstract class AbstractCsvDataProvider<E>
extends AbstractCsvReader<E>
implements DataProvider {
    private static final Map<Class<?>, CsvPropertyConverter<?>> PROPERTY_CONVERTER = new HashMap();
    private final Collection<E> entities = new ArrayList();
    private final Map<String, CsvPropertyConverter<?>> columnConverter = new HashMap();
    private final Map<String, String> columnProperties = new HashMap<String, String>();
    private boolean ignoreUnknownColumns;

    static {
        PROPERTY_CONVERTER.put(Number.class, new CsvNumberConverter());
        PROPERTY_CONVERTER.put(Boolean.class, new CsvBooleanConverter());
        PROPERTY_CONVERTER.put(Date.class, new CsvDateConverter());
        PROPERTY_CONVERTER.put(Enum.class, new CsvEnumConverter());
        PROPERTY_CONVERTER.put(Character.class, new CsvCharacterConverter());
    }

    protected AbstractCsvDataProvider(File importPath) {
        super(importPath);
    }

    public void addColumnMapping(String column, String property) {
        this.columnProperties.put(column, property);
    }

    public void addConverter(String column, CsvPropertyConverter<?> converter) {
        this.columnConverter.put(column, converter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean applyColumn(E entity, String column, String value) {
        String property = this.columnProperties.get(column);
        if (property == null) {
            property = column;
        }
        String setter = "set" + StringUtils.capitalize((String)property);
        try {
            Method[] methodArray = entity.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    if (this.ignoreUnknownColumns) break;
                    throw new IllegalArgumentException("Could not find a public method '" + setter + "' in " + entity.getClass());
                }
                Method method = methodArray[n2];
                if (method.getName().equals(setter) && method.getParameterTypes().length == 1 && !Modifier.isStatic(method.getModifiers())) {
                    method.invoke(entity, this.convertColumn(column, method.getParameterTypes()[0], value));
                    return true;
                }
                ++n2;
            }
            return false;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void buildEntities() throws IOException {
        this.entities.addAll(this.readImportFiles());
    }

    protected <T> T convertColumn(String column, Class<T> targetType, String value) {
        CsvPropertyConverter<Object> converter = this.columnConverter.get(column);
        if (converter == null) {
            if (String.class == targetType) {
                return (T)value;
            }
            converter = this.findConverter(targetType);
            if (converter == null) {
                throw new IllegalArgumentException("Could not find a converter for " + targetType);
            }
        }
        return (T)converter.convert(targetType, value);
    }

    @Override
    protected Collection<? extends E> createEntities(Map<String, String> row) {
        return Collections.singleton(this.createEntity(row));
    }

    protected E createEntity() {
        try {
            return this.getEntityClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ModelException("Could not find public no-arg constructor for " + this.getEntityClass(), (Throwable)e);
        }
    }

    protected E createEntity(Map<String, String> row) {
        E entity = this.createEntity();
        for (Map.Entry<String, String> column : row.entrySet()) {
            this.applyColumn(entity, column.getKey(), column.getValue());
        }
        return entity;
    }

    private <T> CsvPropertyConverter<? super T> findConverter(Class<T> targetType) {
        if (targetType == null) {
            return null;
        }
        if (targetType.isPrimitive()) {
            return this.findConverter(ClassUtils.primitiveToWrapper(targetType));
        }
        CsvPropertyConverter<Object> converter = PROPERTY_CONVERTER.get(targetType);
        if (converter == null && (converter = this.findConverter(targetType.getSuperclass())) == null) {
            Class<?>[] classArray = targetType.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interf = classArray[n2];
                converter = this.findConverter(interf);
                if (converter != null) {
                    return converter;
                }
                ++n2;
            }
        }
        return converter;
    }

    protected Class<E> getEntityClass() {
        return ClassUtil.getActualTypeBinding(this.getClass(), AbstractCsvDataProvider.class, 0);
    }

    @Override
    public int getOrder() {
        return 0;
    }

    protected void useTableColumns() {
        EntityClass description = new GeneratorContext().getDescription(this.getEntityClass());
        for (Property property : description.getAllProperties()) {
            SingularProperty singularProperty;
            if (!(property instanceof SingularProperty) || !(singularProperty = (SingularProperty)property).isTableColumn() || singularProperty.getColumn() == null) continue;
            this.columnProperties.put(singularProperty.getColumn(), singularProperty.getAttribute().getName());
        }
    }

    @Override
    public void writeEntities(EntitySqlGenerator sqlGenerator) throws IOException {
        sqlGenerator.write(this.entities);
    }

    public Collection<E> getEntities() {
        return this.entities;
    }

    public boolean isIgnoreUnknownColumns() {
        return this.ignoreUnknownColumns;
    }

    public void setIgnoreUnknownColumns(boolean ignoreUnknownColumns) {
        this.ignoreUnknownColumns = ignoreUnknownColumns;
    }
}

