/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.comment.CommentMatcher;
import org.supercsv.comment.CommentMatches;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public abstract class AbstractCsvReader<R> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCsvReader.class);
    private final List<File> importFiles = new ArrayList<File>();

    private static boolean isNotEmpty(List<String> values) {
        return values.size() > 1 || values.size() == 1 && StringUtils.isNotBlank((String)values.get(0));
    }

    public AbstractCsvReader(File importPath) {
        if (!importPath.exists()) {
            throw new IllegalArgumentException("Path not found: " + importPath.getAbsolutePath());
        }
        if (importPath.isDirectory()) {
            this.importFiles.addAll(Arrays.asList(importPath.listFiles((FilenameFilter)new SuffixFileFilter(".csv"))));
        } else {
            this.importFiles.add(importPath);
        }
    }

    protected abstract Collection<? extends R> createEntities(Map<String, String> var1);

    protected Charset getDefaultEncoding() {
        return Charsets.UTF_8;
    }

    protected CsvListReader openCsvListReader(File importFile) throws IOException {
        String charset;
        BOMInputStream inputStream;
        InputStream fileStream = new FileInputStream(importFile);
        if (importFile.getName().toLowerCase().endsWith(".gz")) {
            fileStream = new GZIPInputStream(fileStream);
        }
        if ((inputStream = new BOMInputStream(fileStream, false, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE})).hasBOM()) {
            charset = inputStream.getBOMCharsetName();
            log.info("BOM detected. Using {} as encoding", (Object)charset);
        } else {
            charset = this.getDefaultEncoding().toString();
            log.info("No BOM detected. Assuming {} as encoding", (Object)charset);
        }
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, charset);
        return new CsvListReader((Reader)reader, new CsvPreference.Builder(CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE).skipComments((CommentMatcher)new CommentMatches("(//|/\\*|#|;).*")).build());
    }

    /*
     * Unable to fully structure code
     */
    protected Collection<R> readImportFiles() throws IOException {
        entities = new ArrayList<R>();
        for (File importFile : this.importFiles) {
            AbstractCsvReader.log.info("Reading entities from {}...", (Object)importFile);
            var4_4 = null;
            var5_6 = null;
            try {
                csvList = this.openCsvListReader(importFile);
                header = csvList.getHeader(true);
                if (!ArrayUtils.isEmpty((Object[])header)) ** GOTO lbl16
                AbstractCsvReader.log.error("Ignoring {}, as no header was found", (Object)importFile);
                if (csvList == null) continue;
                csvList.close();
                try {
                    continue;
lbl16:
                    // 1 sources

                    columnNames = new HashMap<Object, Integer>();
                    i = 0;
                    while (i < header.length) {
                        if (header[i] != null) {
                            columnNames.put(header[i], i);
                        }
                        ++i;
                    }
                    while ((values = csvList.read()) != null) {
                        if (!AbstractCsvReader.isNotEmpty(values)) continue;
                        row = new HashMap<String, String>();
                        for (Map.Entry<K, V> column : columnNames.entrySet()) {
                            if ((Integer)column.getValue() >= values.size()) continue;
                            row.put((String)column.getKey(), (String)values.get((Integer)column.getValue()));
                        }
                        entities.addAll(this.createEntities(row));
                    }
                    if (csvList == null) continue;
                }
                catch (Throwable var4_5) {
                    if (csvList != null) {
                        csvList.close();
                    }
                    throw var4_5;
                }
                csvList.close();
            }
            catch (Throwable var5_7) {
                if (var4_4 == null) {
                    var4_4 = var5_7;
                } else if (var4_4 != var5_7) {
                    var4_4.addSuppressed(var5_7);
                }
                throw var4_4;
            }
        }
        return entities;
    }
}

