/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.csv;

import java.text.Format;
import java.text.ParseException;
import org.fastnate.data.csv.CsvPropertyConverter;

public class CsvFormatConverter<T>
implements CsvPropertyConverter<T> {
    private final Format[] formats;

    public CsvFormatConverter(Format ... formats) {
        this.formats = formats;
    }

    @Override
    public T convert(Class<? extends T> targetType, String value) {
        if (value == null) {
            return null;
        }
        ParseException firstError = null;
        Format[] formatArray = this.formats;
        int n = this.formats.length;
        int n2 = 0;
        while (n2 < n) {
            Format format = formatArray[n2];
            try {
                return (T)format.parseObject(value);
            }
            catch (ParseException e) {
                if (firstError == null) {
                    firstError = e;
                }
                ++n2;
            }
        }
        throw new IllegalArgumentException(value, firstError);
    }
}

