/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.csv;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.fastnate.data.csv.CsvPropertyConverter;

public final class CsvMapConverter<K, T>
implements CsvPropertyConverter<T> {
    private final Map<K, T> map;
    private final Constructor<K> keyConstructor;

    public static <N extends Number, V> CsvMapConverter<N, V> create(Map<N, V> map, Class<N> numberClass) {
        try {
            return new CsvMapConverter<N, V>(map, numberClass.getConstructor(String.class));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The given number class is not instantiable.", e);
        }
    }

    public static <V> CsvMapConverter<String, V> create(Map<String, V> map) {
        return new CsvMapConverter<String, V>(map, null);
    }

    @Override
    public T convert(Class<? extends T> targetType, String value) {
        String key;
        if (value == null || value.length() == 0) {
            return null;
        }
        if (this.keyConstructor != null) {
            try {
                key = this.keyConstructor.newInstance(value);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            key = value;
        }
        T t = this.map.get(key);
        if (t == null) {
            throw new IllegalArgumentException("Can't find value in map: " + value);
        }
        return t;
    }

    private CsvMapConverter(Map<K, T> map, Constructor<K> keyConstructor) {
        this.map = map;
        this.keyConstructor = keyConstructor;
    }
}

