/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class ClassUtil {
    private static <I> Type getActualTypeArgument(Class<? extends I> instanceClass, Class<I> superClass, int argumentIndex) {
        ArrayList<Type> parents = new ArrayList<Type>();
        parents.add(instanceClass.getGenericSuperclass());
        parents.addAll(Arrays.asList(instanceClass.getGenericInterfaces()));
        for (Type parentType : parents) {
            Class parentClass;
            Class clazz = parentClass = parentType instanceof ParameterizedType ? (Class)((ParameterizedType)parentType).getRawType() : (Class)parentType;
            if (superClass.equals(parentClass)) {
                return ((ParameterizedType)parentType).getActualTypeArguments()[argumentIndex];
            }
            if (parentClass == null || !superClass.isAssignableFrom(parentClass)) continue;
            Type type = ClassUtil.getActualTypeArgument(parentClass.asSubclass(superClass), superClass, argumentIndex);
            if (type instanceof Class) {
                return type;
            }
            if (!(type instanceof TypeVariable)) continue;
            return ((ParameterizedType)parentType).getActualTypeArguments()[Arrays.asList(parentClass.getTypeParameters()).indexOf(type)];
        }
        return null;
    }

    public static <T, I> Class<T> getActualTypeBinding(Class<? extends I> instanceClass, Class<I> superClass, int argumentIndex) {
        Type type = ClassUtil.getActualTypeArgument(instanceClass, superClass, argumentIndex);
        if (type instanceof TypeVariable) {
            type = ((TypeVariable)type).getBounds()[0];
        }
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        throw new NoSuchElementException("Can't find binding for the " + argumentIndex + ". argument of " + superClass + " in " + instanceClass);
    }

    private ClassUtil() {
    }
}

