/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data;

import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import org.fastnate.data.DataProvider;
import org.fastnate.data.DataProviderFactory;
import org.fastnate.data.EntityImporter;
import org.fastnate.data.files.DataFolder;
import org.fastnate.generator.context.GeneratorContext;
import org.reflections.Reflections;

public abstract class AbstractDataProviderFactory
implements DataProviderFactory {
    protected Reflections buildReflections(EntityImporter importer) {
        String packages = EntityImporter.class.getPackage().getName() + ";" + importer.getSettings().getProperty("fastnate.data.provider.packages", "").trim();
        Reflections reflections = new Reflections((Object[])packages.split("[\\s;,:]+"));
        reflections.getTypesAnnotatedWith(Entity.class).forEach(arg_0 -> ((GeneratorContext)importer.getContext()).getDescription(arg_0));
        return reflections;
    }

    protected <E> E findImporterDependency(EntityImporter importer, Class<E> dependencyClass) {
        if (dependencyClass == EntityImporter.class) {
            return (E)importer;
        }
        if (dependencyClass == GeneratorContext.class) {
            return (E)importer.getContext();
        }
        if (dependencyClass == DataFolder.class) {
            return (E)importer.getDataFolder();
        }
        if (dependencyClass == Properties.class) {
            return (E)importer.getSettings();
        }
        return null;
    }

    protected List<Class<? extends DataProvider>> findProviderClasses(Reflections reflections) {
        Set providerClasses = reflections.getSubTypesOf(DataProvider.class);
        ServiceLoader<DataProvider> serviceLoader = ServiceLoader.load(DataProvider.class);
        serviceLoader.forEach(provider -> providerClasses.add(provider.getClass()));
        return providerClasses.stream().sorted(Comparator.comparing(Class::getName)).collect(Collectors.toList());
    }
}

