/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.fastnate.data.EntityImporter;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.SchemaAutoTooling;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.tool.hbm2ddl.ImportScriptException;

public class DatabaseStartupImport
implements SessionFactoryObserver {
    private static final long serialVersionUID = 1L;

    public void sessionFactoryClosed(SessionFactory factory) {
    }

    public void sessionFactoryCreated(SessionFactory factory) {
        SchemaAutoTooling autoTooling = factory.getSessionFactoryOptions().getSchemaAutoTooling();
        if (autoTooling == SchemaAutoTooling.CREATE || autoTooling == SchemaAutoTooling.CREATE_DROP) {
            SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)factory;
            try (Connection connection = ((ConnectionProvider)sessionFactoryImplementor.getServiceRegistry().getService(ConnectionProvider.class)).getConnection();){
                new EntityImporter(new Properties()).importData(connection);
            }
            catch (IOException | SQLException e) {
                throw new ImportScriptException("Could not import SQL data: " + e, (Throwable)e);
            }
        }
    }
}

