/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import lombok.Generated;
import org.fastnate.data.AbstractDataProviderFactory;
import org.fastnate.data.DataProvider;
import org.fastnate.data.EntityImporter;
import org.fastnate.generator.context.ModelException;

public class DefaultDataProviderFactory
extends AbstractDataProviderFactory {
    protected <C extends DataProvider> C addProvider(EntityImporter importer, Class<C> providerClass) {
        Constructor<?>[] constructors = providerClass.getConstructors();
        ModelException.test((constructors.length > 0 ? 1 : 0) != 0, (String)"No public constructor found for {}", (Object[])new Object[]{providerClass});
        Arrays.sort(constructors, Comparator.comparingInt(c -> c.getParameterTypes().length).thenComparing(Constructor::toGenericString));
        for (Constructor<?> constructor : constructors) {
            Object provider = this.addProvider(importer, constructor);
            if (provider == null) continue;
            return (C)provider;
        }
        return null;
    }

    protected <C extends DataProvider> C addProvider(EntityImporter importer, Constructor<C> constructor) {
        MaxOrder maxOrder = new MaxOrder();
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] params = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object parameter = this.findDependency(importer, parameterTypes[i], maxOrder);
            if (parameter == null) {
                return null;
            }
            params[i] = parameter;
        }
        ArrayList<Consumer<DataProvider>> resources = new ArrayList<Consumer<DataProvider>>();
        if (!this.findResourceFields(importer, constructor.getDeclaringClass(), resources, maxOrder) || !this.findResourceSetters(importer, constructor.getDeclaringClass(), resources, new HashSet<String>(), maxOrder)) {
            return null;
        }
        try {
            DataProvider provider = (DataProvider)constructor.newInstance(params);
            resources.forEach(resource -> resource.accept(provider));
            this.invokePostConstruct(constructor.getDeclaringClass(), new HashSet<String>(), provider);
            importer.addDataProvider(provider, maxOrder.getValue());
            return (C)provider;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void createDataProviders(EntityImporter importer) {
        List<Class<? extends DataProvider>> providerClasses = this.findProviderClasses(this.buildReflections(importer));
        while (!providerClasses.isEmpty()) {
            int previousSize = providerClasses.size();
            Iterator<Class<? extends DataProvider>> iterator = providerClasses.iterator();
            while (iterator.hasNext()) {
                Class<? extends DataProvider> providerClass = iterator.next();
                if (!Modifier.isAbstract(providerClass.getModifiers()) && providerClass.getConstructors().length != 0 && this.addProvider(importer, providerClass) == null) continue;
                iterator.remove();
            }
            ModelException.test((providerClasses.size() < previousSize ? 1 : 0) != 0, (String)"Can't instantiate the following providers (possibly because of circular or missing dependencies): {}", (Object[])new Object[]{providerClasses});
        }
    }

    private <E> E findDependency(EntityImporter importer, Class<E> parameterType, MaxOrder maxOrder) {
        E provider;
        E dependency = this.findImporterDependency(importer, parameterType);
        if (dependency != null) {
            return dependency;
        }
        if (DataProvider.class.isAssignableFrom(parameterType) && (provider = importer.findDataProvider(parameterType)) != null) {
            maxOrder.add((DataProvider)provider);
            return provider;
        }
        return null;
    }

    private boolean findResourceFields(EntityImporter importer, Class<?> instanceClass, List<Consumer<DataProvider>> resources, MaxOrder maxOrder) {
        if (instanceClass != Object.class) {
            if (!this.findResourceFields(importer, instanceClass.getSuperclass(), resources, maxOrder)) {
                return false;
            }
            for (Field field : instanceClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Resource.class)) continue;
                Object parameter = this.findDependency(importer, field.getType(), maxOrder);
                if (parameter == null) {
                    return false;
                }
                resources.add(provider -> {
                    field.setAccessible(true);
                    try {
                        field.set(provider, parameter);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                });
            }
        }
        return true;
    }

    private boolean findResourceSetters(EntityImporter importer, Class<?> instanceClass, List<Consumer<DataProvider>> resources, Set<String> injectedMethods, MaxOrder maxOrder) {
        if (instanceClass != Object.class) {
            if (!this.findResourceSetters(importer, instanceClass.getSuperclass(), resources, injectedMethods, maxOrder)) {
                return false;
            }
            for (Method method : instanceClass.getDeclaredMethods()) {
                Class<?>[] parameterTypes;
                if (!method.isAnnotationPresent(Resource.class) || (parameterTypes = method.getParameterTypes()).length != 1 || !Modifier.isPrivate(method.getModifiers()) && !injectedMethods.add(method.getName())) continue;
                Object parameter = this.findDependency(importer, parameterTypes[0], maxOrder);
                if (parameter == null) {
                    return false;
                }
                resources.add(provider -> {
                    method.setAccessible(true);
                    try {
                        method.invoke(provider, parameter);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new IllegalStateException(e);
                    }
                });
            }
        }
        return true;
    }

    private void invokePostConstruct(Class<?> instanceClass, Set<String> calledMethods, DataProvider provider) {
        if (instanceClass != Object.class) {
            this.invokePostConstruct(instanceClass.getSuperclass(), calledMethods, provider);
            for (Method method : instanceClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(PostConstruct.class) || !Modifier.isPrivate(method.getModifiers()) && !calledMethods.add(method.getName())) continue;
                method.setAccessible(true);
                try {
                    method.invoke((Object)provider, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private static final class MaxOrder {
        private int value = Integer.MIN_VALUE;

        public void add(DataProvider provider) {
            if (provider.getOrder() > this.value) {
                this.value = provider.getOrder();
            }
        }

        @Generated
        public int getValue() {
            return this.value;
        }

        @Generated
        public void setValue(int value) {
            this.value = value;
        }

        @Generated
        public MaxOrder() {
        }
    }
}

