/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.fastnate.data.DataProvider;
import org.fastnate.data.DataProviderFactory;
import org.fastnate.data.DefaultDataProviderFactory;
import org.fastnate.data.files.DataFile;
import org.fastnate.data.files.DataFolder;
import org.fastnate.data.files.FsDataFile;
import org.fastnate.data.files.FsDataFolder;
import org.fastnate.data.files.VfsDataFolder;
import org.fastnate.generator.EntitySqlGenerator;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.statements.ConnectedStatementsWriter;
import org.fastnate.generator.statements.FileStatementsWriter;
import org.fastnate.generator.statements.StatementsWriter;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.vfs.Vfs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityImporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityImporter.class);
    public static final String GENERATION_ABORTED_MESSAGE = "!!! GENERATION ABORTED !!!";
    public static final String DATA_FOLDER_KEY = "fastnate.data.folder";
    public static final String OUTPUT_FILE_KEY = "fastnate.data.sql.output.file";
    public static final String OUTPUT_ENCODING_KEY = "fastnate.data.sql.output.encoding";
    public static final String PREFIX_KEY = "fastnate.data.sql.prefix";
    public static final String POSTFIX_KEY = "fastnate.data.sql.postfix";
    public static final String FACTORY_KEY = "fastnate.data.provider.factory";
    public static final String PACKAGES_KEY = "fastnate.data.provider.packages";
    public static final String ENTITY_PACKAGES_KEY = "fastnate.data.entity.packages";
    public static final String STATEMENTS_WRITER_KEY = "fastnate.data.statements.writer";
    private final DataFolder dataFolder;
    private final GeneratorContext context;
    private final List<DataProvider> dataProviders = new ArrayList<DataProvider>();

    private static DataFolder findDataFolder(GeneratorContext context) {
        String dataFolderPath = context.getSettings().getProperty(DATA_FOLDER_KEY, ".");
        File dataFolderDir = new File(dataFolderPath);
        try {
            if (dataFolderDir.isDirectory()) {
                log.info("Using directory {} as data folder", (Object)dataFolderDir.getAbsolutePath());
                return new FsDataFolder(dataFolderDir);
            }
            if (dataFolderDir.isFile() && (dataFolderDir.getName().endsWith(".jar") || dataFolderDir.getName().endsWith(".zip"))) {
                log.info("Using ZIP file {} as data folder", (Object)dataFolderDir.getAbsolutePath());
                return new VfsDataFolder(Collections.singletonList(Vfs.fromURL((URL)dataFolderDir.toURI().toURL(), (Vfs.UrlType[])new Vfs.UrlType[]{Vfs.DefaultUrlTypes.jarFile})));
            }
            if (dataFolderPath.matches("(?i)[-a-z0-9_]+(\\.[-a-z0-9_]+)*")) {
                log.info("Using package \"{}\" as data folder", (Object)dataFolderPath);
                return new VfsDataFolder(ClasspathHelper.forClassLoader().stream().map(Vfs::fromURL).collect(Collectors.toList())).getPath(dataFolderPath.replace('.', '/'));
            }
            throw new IllegalArgumentException("Data folder not found: " + dataFolderPath);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Can't generate URL for data folder: " + e, e);
        }
    }

    public static void main(String[] args) throws IOException {
        Properties settings = new Properties(System.getProperties());
        if (args.length > 0) {
            if (new File(args[0]).isDirectory()) {
                settings.put(DATA_FOLDER_KEY, args[0]);
                if (args.length > 1) {
                    settings.put(OUTPUT_FILE_KEY, args[1]);
                }
            } else {
                settings.put(OUTPUT_FILE_KEY, args[0]);
                if (args.length > 1) {
                    settings.put(DATA_FOLDER_KEY, args[1]);
                }
            }
        }
        new EntityImporter(settings).importData();
    }

    public EntityImporter() {
        this(new Properties());
    }

    public EntityImporter(GeneratorContext context) {
        this.context = context;
        this.dataFolder = EntityImporter.findDataFolder(context);
        String entityPackages = this.getSettings().getProperty(ENTITY_PACKAGES_KEY, "").trim();
        if (!entityPackages.isEmpty()) {
            Reflections reflections = new Reflections((Object[])entityPackages.split("[\\s;,:]+"));
            reflections.getTypesAnnotatedWith(Entity.class).forEach(arg_0 -> ((GeneratorContext)context).getDescription(arg_0));
        }
        log.info("Building all instances of {}", (Object)DataProvider.class.getSimpleName());
        String providerFactoryName = this.getSettings().getProperty(FACTORY_KEY, "");
        if (providerFactoryName.isEmpty()) {
            try {
                Class.forName("javax.inject.Inject");
                providerFactoryName = "org.fastnate.data.InjectDataProviderFactory";
            }
            catch (ClassNotFoundException e) {
                providerFactoryName = DefaultDataProviderFactory.class.getName();
            }
        }
        try {
            Class<?> providerFactoryClass = Class.forName(providerFactoryName);
            DataProviderFactory providerFactory = (DataProviderFactory)providerFactoryClass.newInstance();
            providerFactory.createDataProviders(this);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find DataProviderFactory: " + providerFactoryName, e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Could not create DataProviderFactory: " + providerFactoryName, e);
        }
    }

    public EntityImporter(Properties settings) {
        this(new GeneratorContext(settings));
    }

    public void addDataProvider(DataProvider provider) {
        this.addDataProvider(provider, provider.getOrder());
    }

    public void addDataProvider(DataProvider provider, int maximumOrderOfDepenendencies) {
        int index;
        int order = Math.max(maximumOrderOfDepenendencies, provider.getOrder());
        for (index = this.dataProviders.size(); index > 0 && this.dataProviders.get(index - 1).getOrder() > order; --index) {
        }
        this.dataProviders.add(index, provider);
    }

    public <P extends DataProvider> P findDataProvider(Class<P> providerClass) {
        return (P)((DataProvider)providerClass.cast(this.dataProviders.stream().filter(providerClass::isInstance).findFirst().orElse(null)));
    }

    private Charset getEncoding() {
        return Charset.forName(this.getSettings().getProperty(OUTPUT_ENCODING_KEY, "UTF-8"));
    }

    public Properties getSettings() {
        return this.context.getSettings();
    }

    public void importData() throws IOException {
        String statementsWriter = this.getSettings().getProperty(STATEMENTS_WRITER_KEY, FileStatementsWriter.class.getSimpleName());
        if (statementsWriter.indexOf(46) < 0) {
            statementsWriter = "org.fastnate.generator.statements." + statementsWriter;
        }
        try {
            log.info("Using {} as statements writer", (Object)statementsWriter);
            Class<?> statementsWriterClass = Class.forName(statementsWriter);
            StatementsWriter writer = (StatementsWriter)statementsWriterClass.getConstructor(GeneratorContext.class).newInstance(this.context);
            try (EntitySqlGenerator generator = new EntitySqlGenerator(this.context, writer);){
                if (writer instanceof ConnectedStatementsWriter) {
                    this.importData(generator, ((ConnectedStatementsWriter)writer).getConnection());
                } else {
                    this.importData(generator);
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unknown statements writer: " + statementsWriter, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Statements writer needs a (GeneratorContext) constructor: " + statementsWriter, e);
        }
        catch (IllegalAccessException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not build statements writer: " + statementsWriter, e);
        }
    }

    public void importData(Connection connection) throws IOException, SQLException {
        try (EntitySqlGenerator generator = new EntitySqlGenerator(this.context, connection);){
            this.importData(generator, connection);
        }
        catch (IOException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw e;
        }
    }

    public void importData(EntitySqlGenerator generator) throws IOException {
        try {
            String dialect = this.context.getDialect().getClass().getSimpleName();
            log.info("Using {} for SQL generation.", (Object)dialect);
            for (DataProvider provider : this.dataProviders) {
                provider.buildEntities();
            }
            generator.writeComment("Generated by Fastnate EntityImporter for " + dialect);
            this.writePropertyPart(generator, PREFIX_KEY);
            for (DataProvider provider : this.dataProviders) {
                generator.writeSectionSeparator();
                generator.writeComment("Data from " + provider.getClass().getSimpleName());
                provider.writeEntities(generator);
                log.info("Generated SQL for {}", provider.getClass());
            }
            generator.writeAlignmentStatements();
            this.writePropertyPart(generator, POSTFIX_KEY);
        }
        catch (IOException | Error | RuntimeException e) {
            generator.writeSectionSeparator();
            StringWriter buffer = new StringWriter();
            buffer.write("\n!!! GENERATION ABORTED !!!\n");
            e.printStackTrace(new PrintWriter((Writer)buffer, true));
            generator.writeComment(buffer.toString());
            throw e;
        }
    }

    private void importData(EntitySqlGenerator generator, Connection connection) throws SQLException, IOException {
        boolean transation;
        boolean bl = transation = connection.getAutoCommit() && this.context.getDialect().isFastInTransaction();
        if (transation) {
            connection.setAutoCommit(false);
        }
        try {
            this.importData(generator);
            if (transation) {
                connection.commit();
            }
        }
        catch (IOException | RuntimeException | SQLException e) {
            if (transation) {
                connection.rollback();
            }
            throw e;
        }
        finally {
            if (transation) {
                connection.setAutoCommit(true);
            }
        }
    }

    public void importData(File targetFile) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), this.getEncoding()));){
            this.importData(writer);
            log.info("'{}' generated.", (Object)targetFile.getAbsolutePath());
        }
    }

    public void importData(Writer writer) throws IOException {
        try (EntitySqlGenerator generator = new EntitySqlGenerator(this.context, writer);){
            this.importData(generator);
        }
    }

    private void writePropertyPart(EntitySqlGenerator generator, String property) throws IOException {
        if (!(generator.getWriter() instanceof FileStatementsWriter)) {
            return;
        }
        Writer writer = ((FileStatementsWriter)generator.getWriter()).getWriter();
        String propertyValue = StringUtils.trimToNull((String)this.getSettings().getProperty(property));
        if (propertyValue != null) {
            generator.writeSectionSeparator();
            if (propertyValue.endsWith(".sql")) {
                String[] fileNames;
                for (String fileName : fileNames = propertyValue.split("[\\n\\" + File.pathSeparatorChar + ",;]+")) {
                    File sqlFile = new File(fileName);
                    DataFile sqlDataFile = sqlFile.isAbsolute() ? (sqlFile.isFile() ? new FsDataFile(sqlFile) : null) : this.dataFolder.findFile(fileName);
                    if (sqlDataFile != null) {
                        try (InputStreamReader input = new InputStreamReader(sqlDataFile.open(), this.getEncoding());){
                            int read;
                            generator.writeComment(fileName);
                            int bufferSize = 1024;
                            char[] buffer = new char[1024];
                            while ((read = input.read(buffer)) > 0) {
                                writer.write(buffer, 0, read);
                            }
                            writer.write("\n");
                            continue;
                        }
                    }
                    generator.writeComment("Ignored missing file: " + fileName);
                }
            } else {
                generator.writeComment(property);
                writer.write(propertyValue);
                writer.write("\n");
            }
        }
    }

    @Generated
    public DataFolder getDataFolder() {
        return this.dataFolder;
    }

    @Generated
    public GeneratorContext getContext() {
        return this.context;
    }

    @Generated
    public List<DataProvider> getDataProviders() {
        return this.dataProviders;
    }
}

