/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Resource;
import lombok.Generated;
import org.fastnate.data.DataProvider;
import org.fastnate.generator.EntitySqlGenerator;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.SingularProperty;

public class EntityRegistration
implements DataProvider {
    @Resource
    private final GeneratorContext context;
    private final Map<Class<?>, Map<UniqueKey, Object>> entities = new HashMap();

    private <E> void addEntity(Map<UniqueKey, Object> uniqueEntities, E entity, String[] propertyNames, Object[] propertyValues) {
        UniqueKey uniqueKey = new UniqueKey(propertyNames, propertyValues);
        Object oldValue = uniqueEntities.put(uniqueKey, entity);
        if (oldValue instanceof InvokeLaterHandle) {
            for (Consumer invoker : ((InvokeLaterHandle)oldValue).getConsumer()) {
                invoker.accept(entity);
            }
        } else if (oldValue != null && !oldValue.equals(entity)) {
            throw new IllegalArgumentException("More than one entity of type \"" + this.context.getDescription(entity) + "\" registered for " + uniqueKey);
        }
    }

    @Override
    public void buildEntities() throws IOException {
    }

    public <E> E findEntity(Class<E> entityClass, Object uniqueValue) {
        Map<UniqueKey, Object> uniqueValues = this.entities.get(entityClass);
        if (uniqueValues != null) {
            for (Map.Entry<UniqueKey, Object> entry : uniqueValues.entrySet()) {
                Object value;
                if (entry.getKey().getProperties().length != 1 || !uniqueValue.equals(entry.getKey().getValues()[0]) || (value = entry.getValue()) instanceof InvokeLaterHandle) continue;
                return (E)value;
            }
        }
        return null;
    }

    public <E> E findEntity(Class<E> entityClass, String uniqueProperty, Object uniqueValue) {
        return this.findEntity(entityClass, new String[]{uniqueProperty}, new Object[]{uniqueValue});
    }

    public <E> E findEntity(Class<E> entityClass, String[] uniqueProperties, Object[] uniqueValues) {
        Object value;
        Map<UniqueKey, Object> uniqueEntites = this.entities.get(entityClass);
        if (uniqueEntites != null && !((value = uniqueEntites.get(new UniqueKey(uniqueProperties, uniqueValues))) instanceof InvokeLaterHandle)) {
            return (E)value;
        }
        return null;
    }

    public <E> void invokeOnEntity(Class<E> entityClass, Object uniqueValue, Consumer<E> invoker) {
        this.invokeOnEntity(this.context.getDescription(entityClass), uniqueValue, invoker);
    }

    public <E> void invokeOnEntity(Class<E> entityClass, String uniqueProperty, Object uniqueValue, Consumer<E> invoker) {
        this.invokeOnEntity(entityClass, new String[]{uniqueProperty}, new Object[]{uniqueValue}, invoker);
    }

    public <E> void invokeOnEntity(Class<E> entityClass, String[] uniqueProperties, Object[] uniqueValues, Consumer<E> invoker) {
        Map uniqueEntites = this.entities.computeIfAbsent(entityClass, c -> new HashMap());
        Object entity = uniqueEntites.computeIfAbsent(new UniqueKey(uniqueProperties, uniqueValues), v -> new InvokeLaterHandle());
        if (entity instanceof InvokeLaterHandle) {
            ((InvokeLaterHandle)entity).getConsumer().add(invoker);
        } else {
            invoker.accept(entity);
        }
    }

    public <E> void invokeOnEntity(E templateEntity, Consumer<E> invoker) {
        EntityClass description = this.context.getDescription(templateEntity);
        block0: for (List uniqueProperties : description.getAllUniqueProperties()) {
            int size = uniqueProperties.size();
            String[] propertyNames = new String[size];
            Object[] propertyValues = new Object[size];
            for (int i = 0; i < size; ++i) {
                SingularProperty property = (SingularProperty)uniqueProperties.get(i);
                Object value = property.getValue(templateEntity);
                if (value == null) continue block0;
                propertyNames[i] = property.getName();
                propertyValues[i] = value;
            }
            this.invokeOnEntity(description.getEntityClass(), propertyNames, propertyValues, invoker);
            return;
        }
        throw new IllegalArgumentException("No unique property set for entity of type " + description.getEntityClass());
    }

    public <E> void invokeOnEntity(EntityClass<E> entityClass, Object uniqueValue, Consumer<E> invoker) {
        List uniqueProperties = entityClass.getAllUniqueProperties();
        if (uniqueProperties.isEmpty()) {
            throw new IllegalArgumentException("Found no unique properties for " + entityClass);
        }
        if (uniqueProperties.size() != 1 || ((List)uniqueProperties.get(0)).size() != 1) {
            throw new IllegalArgumentException("Found more than one unique property for " + entityClass + ", please decide which to use.");
        }
        this.invokeOnEntity(entityClass.getEntityClass(), ((SingularProperty)((List)uniqueProperties.get(0)).get(0)).getName(), uniqueValue, invoker);
    }

    public <E> void registerEntity(E entity) {
        EntityClass description = this.context.getDescription(entity);
        List uniquePropertySets = description.getAllUniqueProperties();
        if (!uniquePropertySets.isEmpty()) {
            Map uniqueEntities = this.entities.computeIfAbsent(description.getEntityClass(), c -> new HashMap());
            for (List uniqueProperties : uniquePropertySets) {
                int size = uniqueProperties.size();
                String[] propertyNames = new String[size];
                Object[] propertyValues = new Object[size];
                for (int i = 0; i < size; ++i) {
                    SingularProperty property = (SingularProperty)uniqueProperties.get(i);
                    propertyNames[i] = property.getName();
                    propertyValues[i] = property.getValue(entity);
                }
                this.addEntity(uniqueEntities, entity, propertyNames, propertyValues);
            }
        }
    }

    public <E> void registerEntity(E entity, String[] propertyNames, Object[] propertyValues) {
        EntityClass description = this.context.getDescription(entity);
        Map uniqueEntities = this.entities.computeIfAbsent(description.getEntityClass(), c -> new HashMap());
        this.addEntity(uniqueEntities, entity, propertyNames, propertyValues);
    }

    @Override
    public void writeEntities(EntitySqlGenerator sqlGenerator) throws IOException {
        for (Map.Entry<Class<?>, Map<UniqueKey, Object>> classEntry : this.entities.entrySet()) {
            for (Map.Entry<UniqueKey, Object> entry : classEntry.getValue().entrySet()) {
                Object entity = entry.getValue();
                if (entity instanceof InvokeLaterHandle) {
                    throw new IllegalStateException("Could not find " + classEntry.getKey().getSimpleName() + " with " + entry.getKey());
                }
                sqlGenerator.write(entity);
            }
        }
    }

    @Generated
    public EntityRegistration(GeneratorContext context) {
        this.context = context;
    }

    private static final class UniqueKey {
        private static final int HASHCODE_MULTIPLIER = 31;
        private final String[] properties;
        private final Object[] values;
        private final int hashCode;

        UniqueKey(String[] properties, Object[] values) {
            this.properties = properties;
            this.values = values;
            int initialHashCode = 0;
            for (int i = 0; i < properties.length; ++i) {
                initialHashCode = initialHashCode * 31 + properties[i].hashCode();
                Object value = values[i];
                if (value == null) continue;
                initialHashCode = initialHashCode * 31 + value.hashCode();
            }
            this.hashCode = initialHashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UniqueKey) {
                UniqueKey other = (UniqueKey)obj;
                if (other.properties.length == this.properties.length) {
                    for (int i = 0; i < this.properties.length; ++i) {
                        if (!this.properties[i].equals(other.properties[i])) {
                            return false;
                        }
                        Object value = this.values[i];
                        if (!(value == null ? other.values[i] != null : !value.equals(other.values[i]))) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.properties.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.properties[i]).append(" = \"").append(this.values[i]).append('\"');
            }
            return result.toString();
        }

        @Generated
        public String[] getProperties() {
            return this.properties;
        }

        @Generated
        public Object[] getValues() {
            return this.values;
        }
    }

    private static final class InvokeLaterHandle<E> {
        private final List<Consumer<E>> consumer = new ArrayList<Consumer<E>>();

        @Generated
        public List<Consumer<E>> getConsumer() {
            return this.consumer;
        }

        @Generated
        public InvokeLaterHandle() {
        }
    }
}

