/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Qualifier;
import lombok.Generated;
import org.fastnate.data.AbstractDataProviderFactory;
import org.fastnate.data.DataProvider;
import org.fastnate.data.EntityImporter;
import org.fastnate.generator.context.ModelException;
import org.reflections.Reflections;

public class InjectDataProviderFactory
extends AbstractDataProviderFactory {
    private final Map<Dependency, Injection> injections = new HashMap<Dependency, Injection>();
    private EntityImporter importer;
    private Reflections reflections;

    private static Annotation findQualifier(AnnotatedElement annotatedElement) {
        return Arrays.stream(annotatedElement.getAnnotations()).filter(a -> a.getClass().isAnnotationPresent(Qualifier.class)).findFirst().orElse(null);
    }

    private <C> Injection buildInjection(Class<C> instanceClass) {
        ModelException.test((!Modifier.isAbstract(instanceClass.getModifiers()) ? 1 : 0) != 0, (String)"Can't instantiate instance of abstract {}", (Object[])new Object[]{instanceClass});
        Dependency dependency = new Dependency(InjectDataProviderFactory.findQualifier(instanceClass), instanceClass);
        Injection injection = this.injections.get(dependency);
        if (injection != null) {
            ModelException.test((injection.getInstance() != null ? 1 : 0) != 0, (String)"Cicular dependency in {}", (Object[])new Object[]{instanceClass});
            return injection;
        }
        injection = new Injection();
        this.injections.put(dependency, injection);
        Constructor<?>[] constructors = instanceClass.getConstructors();
        ModelException.test((constructors.length > 0 ? 1 : 0) != 0, (String)"No public constructor found for {}", (Object[])new Object[]{instanceClass});
        Constructor<?> potentialConstructor = null;
        for (Constructor<?> constructor : constructors) {
            if (constructor.isAnnotationPresent(Inject.class)) {
                return this.fillInjection(injection, constructor);
            }
            if (constructor.getParameterTypes().length != 0 && potentialConstructor != null) continue;
            potentialConstructor = constructor;
        }
        ModelException.test((potentialConstructor != null ? 1 : 0) != 0, (String)"No constructor found for {}", (Object[])new Object[]{instanceClass});
        return this.fillInjection(injection, potentialConstructor);
    }

    @Override
    public void createDataProviders(EntityImporter parentImporter) {
        this.importer = parentImporter;
        this.reflections = this.buildReflections(parentImporter);
        for (Class<? extends DataProvider> providerClass : this.findProviderClasses(this.reflections)) {
            if (Modifier.isAbstract(providerClass.getModifiers()) || providerClass.getConstructors().length <= 0) continue;
            this.buildInjection(providerClass);
        }
    }

    private <C> Injection fillInjection(Injection injection, Constructor<C> constructor) {
        try {
            constructor.setAccessible(true);
            C instance = constructor.newInstance(this.fillParameters(constructor, injection));
            Class<C> instanceClass = constructor.getDeclaringClass();
            this.injectFields(instanceClass, instance, injection);
            this.injectSetters(instanceClass, new HashSet<String>(), instance, injection);
            this.invokePostInitialize(instanceClass, new HashSet<String>(), instance);
            injection.setInstance(instance);
            if (instance instanceof DataProvider) {
                DataProvider provider = (DataProvider)instance;
                if (provider.getOrder() > injection.getOrder()) {
                    injection.setOrder(provider.getOrder());
                }
                this.importer.addDataProvider(provider, injection.getOrder());
            }
            return injection;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Object[] fillParameters(Executable method, Injection injection) {
        AnnotatedType[] parameterTypes = method.getAnnotatedParameterTypes();
        Object[] params = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            params[i] = this.findDependency(method, parameterTypes[i], injection);
        }
        return params;
    }

    private <C> Object findDependency(Member member, AnnotatedType annotatedType, Injection parentInjection) {
        Class type = (Class)annotatedType.getType();
        Annotation qualifier = InjectDataProviderFactory.findQualifier(annotatedType);
        Dependency dependency = new Dependency(qualifier, type);
        Injection injection = this.injections.get(dependency);
        if (injection == null) {
            Object importerParamer = this.findImporterDependency(this.importer, type);
            if (importerParamer != null) {
                injection = new Injection(Integer.MIN_VALUE, importerParamer);
            } else {
                List possibleImplementations = this.reflections.getSubTypesOf(type).stream().filter(c -> !Modifier.isAbstract(c.getModifiers())).collect(Collectors.toList());
                if (possibleImplementations.isEmpty()) {
                    injection = this.buildInjection(type);
                } else if (possibleImplementations.size() == 1) {
                    injection = this.buildInjection((Class)possibleImplementations.get(0));
                } else if (qualifier != null) {
                    possibleImplementations.removeIf(c -> !Arrays.asList(c.getAnnotationsByType(qualifier.getClass())).contains(qualifier));
                    ModelException.test((!possibleImplementations.isEmpty() ? 1 : 0) != 0, (String)"Could not find subclass of {} with qualifier {} when initializing {}", (Object[])new Object[]{type, qualifier, member});
                    ModelException.test((possibleImplementations.size() == 1 ? 1 : 0) != 0, (String)"More than one possible subclass for {} with qualifier {} found when initializing {}", (Object[])new Object[]{type, qualifier, member});
                    injection = this.buildInjection((Class)possibleImplementations.get(0));
                } else {
                    throw new ModelException("More than one matching subclasses of " + type + " found when initializing " + member + ", use a qualifier for disambiguation");
                }
            }
            this.injections.put(dependency, injection);
        }
        int order = injection.getOrder();
        if (parentInjection.getOrder() < order) {
            parentInjection.setOrder(order);
        }
        return injection.getInstance();
    }

    private void injectFields(Class<?> instanceClass, Object instance, Injection parentInjection) {
        if (instanceClass != Object.class) {
            this.injectFields(instanceClass.getSuperclass(), instance, parentInjection);
            for (Field field : instanceClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Inject.class) && !field.isAnnotationPresent(Resource.class)) continue;
                field.setAccessible(true);
                try {
                    field.set(instance, this.findDependency(field, field.getAnnotatedType(), parentInjection));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private void injectSetters(Class<?> instanceClass, Set<String> injectedMethods, Object instance, Injection parentInjection) {
        if (instanceClass != Object.class) {
            this.injectSetters(instanceClass.getSuperclass(), injectedMethods, instance, parentInjection);
            for (Method method : instanceClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Inject.class) && !method.isAnnotationPresent(Resource.class) || !Modifier.isPrivate(method.getModifiers()) && !injectedMethods.add(method.toGenericString())) continue;
                try {
                    method.invoke(instance, this.fillParameters(method, parentInjection));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private void invokePostInitialize(Class<?> instanceClass, Set<String> calledMethods, Object instance) {
        if (instanceClass != Object.class) {
            this.invokePostInitialize(instanceClass.getSuperclass(), calledMethods, instance);
            for (Method method : instanceClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(PostConstruct.class) || !Modifier.isPrivate(method.getModifiers()) && !calledMethods.add(method.getName())) continue;
                method.setAccessible(true);
                try {
                    method.invoke(instance, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private static final class Injection {
        private int order = Integer.MIN_VALUE;
        private Object instance;

        public String toString() {
            return this.instance == null ? "" : this.instance.toString();
        }

        @Generated
        public int getOrder() {
            return this.order;
        }

        @Generated
        public Object getInstance() {
            return this.instance;
        }

        @Generated
        public void setOrder(int order) {
            this.order = order;
        }

        @Generated
        public void setInstance(Object instance) {
            this.instance = instance;
        }

        @Generated
        public Injection() {
        }

        @Generated
        public Injection(int order, Object instance) {
            this.order = order;
            this.instance = instance;
        }
    }

    private static final class Dependency {
        private final Annotation qualifier;
        private final Class<?> type;

        public String toString() {
            return this.qualifier == null ? this.type.toString() : this.qualifier + " " + this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            Annotation this$qualifier = this.qualifier;
            Annotation other$qualifier = other.qualifier;
            if (this$qualifier == null ? other$qualifier != null : !((Object)this$qualifier).equals(other$qualifier)) {
                return false;
            }
            Class<?> this$type = this.type;
            Class<?> other$type = other.type;
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Annotation $qualifier = this.qualifier;
            result = result * 59 + ($qualifier == null ? 43 : ((Object)$qualifier).hashCode());
            Class<?> $type = this.type;
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public Dependency(Annotation qualifier, Class<?> type) {
            this.qualifier = qualifier;
            this.type = type;
        }
    }
}

