/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.files;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.fastnate.data.files.DataFile;

public interface DataFolder {
    default public DataFile findFile(String name) {
        return this.getFiles().stream().filter(file -> name.equals(file.getName())).findFirst().orElse(null);
    }

    default public DataFolder findFolder(String name) {
        return this.getFolders().stream().filter(folder -> name.equals(folder.getName())).findFirst().orElse(null);
    }

    default public void forAllFiles(BiConsumer<DataFolder, DataFile> consumer) throws IOException {
        for (DataFile dataFile : this.getFiles()) {
            InputStream in = dataFile.open();
            Throwable throwable = null;
            try {
                consumer.accept(this, dataFile);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
        for (DataFolder dataFolder : this.getFolders()) {
            dataFolder.forAllFiles(consumer);
        }
    }

    default public void forAllFiles(Consumer<DataFile> consumer) throws IOException {
        for (DataFile dataFile : this.getFiles()) {
            InputStream in = dataFile.open();
            Throwable throwable = null;
            try {
                consumer.accept(dataFile);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
        for (DataFolder dataFolder : this.getFolders()) {
            dataFolder.forAllFiles(consumer);
        }
    }

    public List<? extends DataFile> getFiles();

    default public DataFolder getFolder(final String name) {
        DataFolder folder = this.findFolder(name);
        if (folder != null) {
            return folder;
        }
        return new DataFolder(){

            @Override
            public DataFile findFile(String name2) {
                return null;
            }

            @Override
            public DataFolder findFolder(String name2) {
                return null;
            }

            @Override
            public List<? extends DataFile> getFiles() {
                return Collections.emptyList();
            }

            @Override
            public List<? extends DataFolder> getFolders() {
                return Collections.emptyList();
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public DataFolder getParent() {
                return DataFolder.this;
            }
        };
    }

    public List<? extends DataFolder> getFolders();

    public String getName();

    public DataFolder getParent();

    default public DataFolder getPath(String path) {
        DataFolder result = this;
        for (String pathElement : path.split("/")) {
            result = result.getFolder(pathElement);
        }
        return result;
    }
}

