/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.files;

import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.fastnate.data.files.DataFile;
import org.fastnate.data.files.DataFolder;
import org.fastnate.data.files.FsDataFile;

public class FsDataFolder
implements DataFolder {
    private final File folder;

    @Override
    public DataFile findFile(String name) {
        File file = new File(this.folder, name);
        if (file.isFile()) {
            return new FsDataFile(file);
        }
        return null;
    }

    @Override
    public DataFolder findFolder(String name) {
        File dir = new File(this.folder, name);
        if (dir.isDirectory()) {
            return new FsDataFolder(dir);
        }
        return null;
    }

    public List<FsDataFile> getFiles() {
        return Stream.of(this.folder.listFiles(file -> file.isFile())).sorted(Comparator.comparing(File::getName)).map(FsDataFile::new).collect(Collectors.toList());
    }

    public List<FsDataFolder> getFolders() {
        return Stream.of(this.folder.listFiles(file -> file.isDirectory())).sorted(Comparator.comparing(File::getName)).map(FsDataFolder::new).collect(Collectors.toList());
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    @Override
    public DataFolder getParent() {
        File parentFile = this.folder.getParentFile();
        if (parentFile == null || !parentFile.isDirectory()) {
            return null;
        }
        return new FsDataFolder(parentFile);
    }

    @Generated
    public FsDataFolder(File folder) {
        this.folder = folder;
    }

    @Generated
    public File getFolder() {
        return this.folder;
    }
}

