/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.files;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.fastnate.data.DataImportException;
import org.fastnate.data.DataProvider;
import org.fastnate.data.EntityRegistration;
import org.fastnate.data.files.DataFile;
import org.fastnate.data.files.DataFolder;
import org.fastnate.generator.EntitySqlGenerator;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.GeneratorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericDataProvider
implements DataProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericDataProvider.class);
    private static final String ENTITIES_FOLDER = "entities";
    @Resource
    private GeneratorContext context;
    @Resource
    private EntityRegistration entityRegistration;
    @Resource
    private DataFolder dataFolder;
    private final List<Collection<?>> entities = new ArrayList();

    @Override
    public void buildEntities() throws IOException {
        this.dataFolder.getFolder(ENTITIES_FOLDER).forAllFiles(this::readImportFile);
    }

    protected EntityClass<?> findEntityClass(DataFile importFile) {
        int dot = importFile.getName().indexOf(46);
        if (dot > 0) {
            String entityName = importFile.getName().substring(0, dot);
            EntityClass entityClass = (EntityClass)this.context.getDescriptionsByName().get(entityName);
            if (entityClass != null) {
                return entityClass;
            }
        }
        for (DataFolder folder = importFile.getFolder(); folder != null; folder = folder.getParent()) {
            String entityName = folder.getName();
            EntityClass entityClass = (EntityClass)this.context.getDescriptionsByName().get(entityName);
            if (entityClass == null) continue;
            return entityClass;
        }
        return null;
    }

    protected abstract Collection<?> importFile(DataFile var1) throws DataImportException, IOException;

    protected abstract boolean isImportFile(DataFile var1);

    private void readImportFile(DataFile file) {
        if (this.isImportFile(file)) {
            try {
                log.info("Reading entities from {}...", (Object)file.getName());
                Collection<?> importedEntities = this.importFile(file);
                if (importedEntities != null && importedEntities.size() > 0) {
                    this.entities.add(importedEntities);
                }
            }
            catch (IOException e) {
                throw new DataImportException(e.getMessage(), file.getName(), e);
            }
        }
    }

    @Override
    public void writeEntities(EntitySqlGenerator sqlGenerator) throws IOException {
        for (Collection<?> subset : this.entities) {
            sqlGenerator.write(subset);
        }
    }

    @Generated
    protected GeneratorContext getContext() {
        return this.context;
    }

    @Generated
    protected EntityRegistration getEntityRegistration() {
        return this.entityRegistration;
    }
}

