/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.files;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import lombok.Generated;
import org.fastnate.data.files.DataFile;
import org.fastnate.data.files.DataFolder;
import org.fastnate.data.files.VfsDataFile;
import org.reflections.vfs.Vfs;

public class VfsDataFolder
implements DataFolder {
    private final List<Vfs.Dir> dirs;
    private final VfsDataFolder parent;
    private final String relativePath;
    private final String name;

    public VfsDataFolder(List<Vfs.Dir> dirs) {
        this(dirs, null, null, null);
    }

    @Override
    public DataFile findFile(String fileName) {
        for (Vfs.Dir dir : this.dirs) {
            for (Vfs.File file : dir.getFiles()) {
                if (!fileName.equals(file.getName()) || !this.isFileFromFolder(file)) continue;
                return new VfsDataFile(this, file);
            }
        }
        return null;
    }

    @Override
    public DataFolder findFolder(String folderName) {
        return new VfsDataFolder(this.dirs, this, this.relativePath == null ? folderName : this.relativePath + '/' + folderName, folderName);
    }

    public List<VfsDataFile> getFiles() {
        ArrayList<VfsDataFile> result = new ArrayList<VfsDataFile>();
        for (Vfs.Dir dir : this.dirs) {
            for (Vfs.File file : dir.getFiles()) {
                if (!this.isFileFromFolder(file)) continue;
                result.add(new VfsDataFile(this, file));
            }
        }
        Collections.sort(result, Comparator.comparing(DataFile::getName));
        return result;
    }

    public List<VfsDataFolder> getFolders() {
        LinkedHashSet<String> folders = new LinkedHashSet<String>();
        ArrayList<VfsDataFolder> result = new ArrayList<VfsDataFolder>();
        for (Vfs.Dir dir : this.dirs) {
            for (Vfs.File file : dir.getFiles()) {
                String folderName;
                int nextSlash;
                int firstChar;
                String path = file.getRelativePath();
                if (this.relativePath == null) {
                    firstChar = 0;
                } else {
                    firstChar = this.relativePath.length() + 1;
                    if (path.length() <= firstChar || path.charAt(firstChar - 1) != '/' || !path.startsWith(this.relativePath)) continue;
                }
                if ((nextSlash = path.indexOf(47, firstChar)) <= 0 || !folders.add(folderName = path.substring(firstChar, nextSlash))) continue;
                result.add(new VfsDataFolder(this.dirs, this, path.substring(0, nextSlash), folderName));
            }
        }
        Collections.sort(result, Comparator.comparing(DataFolder::getName));
        return result;
    }

    private boolean isFileFromFolder(Vfs.File file) {
        String filePath = file.getRelativePath();
        if (this.relativePath == null) {
            return filePath.indexOf(47) < 0;
        }
        int slash = this.relativePath.length();
        return filePath.length() > slash + 1 && filePath.charAt(slash) == '/' && filePath.startsWith(this.relativePath) && filePath.indexOf(47, slash + 1) < 0;
    }

    @Generated
    public VfsDataFolder(List<Vfs.Dir> dirs, VfsDataFolder parent, String relativePath, String name) {
        this.dirs = dirs;
        this.parent = parent;
        this.relativePath = relativePath;
        this.name = name;
    }

    @Override
    @Generated
    public VfsDataFolder getParent() {
        return this.parent;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }
}

