/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.properties;

import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.fastnate.data.properties.PropertyConverter;

public class BooleanConverter
implements PropertyConverter<Boolean>,
Function<String, Boolean> {
    private static final Pattern BOOLEAN_PATTERN = Pattern.compile("(?i)true|1|on|x|[ysoj\u0434].*");

    @Override
    public Boolean apply(String value) {
        return value != null && BOOLEAN_PATTERN.matcher(value.trim()).matches();
    }

    @Override
    public Boolean convert(Class<? extends Boolean> targetType, String value) {
        if (StringUtils.isEmpty((CharSequence)value) && targetType == Boolean.class) {
            return null;
        }
        return this.apply(value);
    }
}

