/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.properties;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.fastnate.data.properties.FormatConverter;

public class DateConverter<D extends Date>
extends FormatConverter<D> {
    public DateConverter() {
        super(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("'T'HH:mm:ss"), new SimpleDateFormat("HH:mm:ss"), new SimpleDateFormat("dd.MM.yy HH:mm:ss"), new SimpleDateFormat("dd.MM.yy"), new SimpleDateFormat("HH:mm:ss"), new SimpleDateFormat("MM/dd/yy HH:mm:ss"), new SimpleDateFormat("MM/dd/yy"), new SimpleDateFormat("dd-MMM-yy"));
    }

    public DateConverter(TimeZone timeZone) {
        this();
        this.getFormats().forEach(format -> ((SimpleDateFormat)format).setTimeZone(timeZone));
    }

    @Override
    public D convert(Class<? extends D> targetType, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Date date = (Date)super.convert(targetType, value);
        if (targetType.isInstance(date)) {
            return (D)date;
        }
        try {
            return (D)((Date)targetType.getConstructor(Long.TYPE).newInstance(date.getTime()));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

