/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.properties;

import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.fastnate.data.properties.PropertyConverter;
import org.fastnate.util.ClassUtil;

public class FormatConverter<T>
implements PropertyConverter<T> {
    private static final Integer DEFAULT_VALUE = 0;
    private final List<Format> formats = new ArrayList<Format>();

    public FormatConverter(Format ... formats) {
        this.formats.addAll(Arrays.asList(formats));
    }

    @Override
    public T convert(Class<? extends T> targetType, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            if (targetType.isPrimitive()) {
                return (T)ClassUtil.convertNumber((Number)DEFAULT_VALUE, targetType);
            }
            return null;
        }
        String trimmedValue = value.trim();
        ParseException firstError = null;
        for (Format format : this.formats) {
            try {
                Object result = format.parseObject(trimmedValue);
                if (result instanceof Number) {
                    return (T)ClassUtil.convertNumber((Number)((Number)result), targetType);
                }
                return (T)result;
            }
            catch (ParseException e) {
                if (firstError != null) continue;
                firstError = e;
            }
        }
        throw new IllegalArgumentException(trimmedValue, firstError);
    }

    @Generated
    public List<Format> getFormats() {
        return this.formats;
    }
}

