/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.properties;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.fastnate.data.properties.PropertyConverter;

public class MapConverter<K, T>
implements PropertyConverter<T>,
Function<String, T> {
    private final Map<K, T> map;
    private final Function<String, K> keyConverter;

    public static <N extends Number, V> MapConverter<N, V> create(Map<N, V> map, Class<N> numberClass) {
        try {
            Constructor keyConstructor = numberClass.getConstructor(String.class);
            return new MapConverter<Number, V>(map, key -> {
                try {
                    return (Number)keyConstructor.newInstance(key);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
            });
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The given number class is not instantiable.", e);
        }
    }

    public static <V> MapConverter<String, V> create(Map<String, V> map) {
        return new MapConverter<String, V>(map, Function.identity());
    }

    @Override
    public T apply(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        K key = this.keyConverter.apply(value);
        T result = this.map.get(key);
        if (result == null) {
            throw new IllegalArgumentException("Can't find value in map: " + value);
        }
        return result;
    }

    @Override
    public T convert(Class<? extends T> targetType, String value) {
        return this.apply(value);
    }

    @Generated
    public MapConverter(Map<K, T> map, Function<String, K> keyConverter) {
        this.map = map;
        this.keyConverter = keyConverter;
    }
}

