/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.properties;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.fastnate.data.properties.PropertyConverter;

public class NumberConverter
implements PropertyConverter<Number> {
    @Override
    public Number convert(Class<? extends Number> targetType, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            if (targetType.isPrimitive()) {
                return this.convert(targetType, "0");
            }
            return null;
        }
        if (targetType == Number.class) {
            return new Float(value);
        }
        Class wrapperType = targetType.isPrimitive() ? ClassUtils.primitiveToWrapper(targetType) : targetType;
        try {
            return (Number)wrapperType.getConstructor(String.class).newInstance(value);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

