/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.properties;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.fastnate.generator.context.CollectionProperty;
import org.fastnate.generator.context.MapProperty;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.context.PluralProperty;

public abstract class PluralPropertyContents<E> {
    public static <E, C, V> PluralPropertyContents<V> create(E entity, PluralProperty<E, C, V> property) {
        PluralPropertyContents collection;
        if (property instanceof MapProperty) {
            collection = new MapCollection();
        } else if (property instanceof CollectionProperty) {
            collection = List.class.isAssignableFrom(property.getType()) ? new ListCollection() : new SetCollection();
        } else {
            throw new ModelException("Can't handle plural property: " + property);
        }
        Object collectionObject = property.getAttribute().getValue(entity);
        if (collectionObject == null) {
            collection.create();
            property.setValue(entity, collection.getCollection());
        } else {
            collection.setCollection(collectionObject);
        }
        return collection;
    }

    public void addElement(E element) {
        this.setElement(0, null, element);
    }

    abstract void create();

    abstract Object getCollection();

    abstract void setCollection(Object var1);

    public abstract void setElement(int var1, Object var2, E var3);

    private static final class SetCollection<E, V>
    extends PluralPropertyContents<V> {
        private Set<V> collection;

        @Override
        void create() {
            this.collection = new LinkedHashSet<V>();
        }

        @Override
        void setCollection(Object value) {
            this.collection = (Set)value;
        }

        @Override
        public void setElement(int index, Object key, V element) {
            this.collection.add(element);
        }

        @Generated
        public SetCollection() {
        }

        @Override
        @Generated
        Set<V> getCollection() {
            return this.collection;
        }
    }

    private static final class MapCollection<E>
    extends PluralPropertyContents<E> {
        private Map<Object, E> collection;

        @Override
        void create() {
            this.collection = new LinkedHashMap<Object, E>();
        }

        @Override
        void setCollection(Object value) {
            this.collection = (Map)value;
        }

        @Override
        public void setElement(int index, Object key, E element) {
            this.collection.put(key, element);
        }

        @Generated
        public MapCollection() {
        }

        @Override
        @Generated
        Map<Object, E> getCollection() {
            return this.collection;
        }
    }

    private static final class ListCollection<E>
    extends PluralPropertyContents<E> {
        private List<E> collection;

        @Override
        public void addElement(E element) {
            this.collection.add(element);
        }

        @Override
        void create() {
            this.collection = new ArrayList();
        }

        @Override
        void setCollection(Object value) {
            this.collection = (List)value;
        }

        @Override
        public void setElement(int index, Object key, E element) {
            while (this.collection.size() <= index) {
                this.collection.add(null);
                this.collection.set(index, element);
            }
        }

        @Generated
        public ListCollection() {
        }

        @Override
        @Generated
        List<E> getCollection() {
            return this.collection;
        }
    }
}

