/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.properties;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.fastnate.data.properties.BooleanConverter;
import org.fastnate.data.properties.CharacterConverter;
import org.fastnate.data.properties.DateConverter;
import org.fastnate.data.properties.EnumConverter;
import org.fastnate.data.properties.NumberConverter;
import org.fastnate.data.properties.PropertyConverter;

public abstract class PropertyDataImporter {
    private static final Map<Class<?>, PropertyConverter<?>> DEFAULT_CONVERTERS = new HashMap();
    private final Map<Class<?>, PropertyConverter<?>> converters = new HashMap(DEFAULT_CONVERTERS);

    public <T> void addConverter(Class<T> type, PropertyConverter<T> converter) {
        this.converters.put(type, converter);
    }

    protected <T> PropertyConverter<T> findConverter(Class<T> propertyClass) {
        if (propertyClass == null) {
            return null;
        }
        if (propertyClass.isPrimitive()) {
            return this.findConverter(ClassUtils.primitiveToWrapper(propertyClass));
        }
        PropertyConverter<?> converter = this.converters.get(propertyClass);
        if (converter != null) {
            return converter;
        }
        for (Class<?> interfaceClass : propertyClass.getInterfaces()) {
            converter = this.findConverter(interfaceClass);
            if (converter == null) continue;
            return converter;
        }
        if (propertyClass.getSuperclass() == null) {
            return null;
        }
        return this.findConverter(propertyClass.getSuperclass());
    }

    static {
        DEFAULT_CONVERTERS.put(String.class, (targetClass, value) -> value);
        DEFAULT_CONVERTERS.put(Number.class, new NumberConverter());
        DEFAULT_CONVERTERS.put(Boolean.class, new BooleanConverter());
        DEFAULT_CONVERTERS.put(Enum.class, new EnumConverter());
        DEFAULT_CONVERTERS.put(Character.class, new CharacterConverter());
        DEFAULT_CONVERTERS.put(Date.class, new DateConverter());
        DEFAULT_CONVERTERS.put(LocalDate.class, (targetType, value) -> LocalDate.parse(value));
        DEFAULT_CONVERTERS.put(LocalDateTime.class, (targetType, value) -> LocalDateTime.parse(value));
        DEFAULT_CONVERTERS.put(LocalTime.class, (targetType, value) -> LocalTime.parse(value));
        DEFAULT_CONVERTERS.put(Duration.class, (targetType, value) -> Duration.parse(value));
        DEFAULT_CONVERTERS.put(byte[].class, (targetType, value) -> Base64.getDecoder().decode(value));
    }
}

