/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import lombok.Generated;
import org.fastnate.data.DataImportException;
import org.fastnate.data.files.DataFile;

public class JaxbImporter<T> {
    private final Class<T> entityClass;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T importFile(DataFile file) throws IOException, DataImportException {
        JAXBContext jaxb;
        try {
            jaxb = JAXBContext.newInstance((Class[])new Class[]{this.entityClass});
        }
        catch (JAXBException e) {
            throw new DataImportException("Could not create context: " + (Object)((Object)e), e);
        }
        try (InputStream stream = file.open();){
            Object object = jaxb.createUnmarshaller().unmarshal(stream);
            return (T)object;
        }
        catch (JAXBException e) {
            throw new DataImportException("Could not parse content: " + (Object)((Object)e), file.getName(), e);
        }
    }

    @Generated
    public JaxbImporter(Class<T> entityClass) {
        this.entityClass = entityClass;
    }
}

