/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.data.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import lombok.Generated;
import org.fastnate.data.DataImportException;
import org.fastnate.data.EntityRegistration;
import org.fastnate.data.files.DataFile;
import org.fastnate.data.properties.PluralPropertyContents;
import org.fastnate.data.properties.PropertyConverter;
import org.fastnate.data.properties.PropertyDataImporter;
import org.fastnate.generator.context.EmbeddedProperty;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.EntityProperty;
import org.fastnate.generator.context.GeneratedIdProperty;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.MapProperty;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.context.PluralProperty;
import org.fastnate.generator.context.PrimitiveProperty;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.context.SingularProperty;

public class XmlDataImporter
extends PropertyDataImporter {
    private static final QName REFERENCE_ATTRIBUTE = new QName("reference");
    private static final QName KEY_ATTRIBUTE = new QName("key");
    private static final Consumer<Object> NOOP_CONSUMER = x -> {};
    private final GeneratorContext context;
    private final EntityRegistration entityRegistration;

    private static void check(boolean condition, XMLEvent event, String errorMessage, Object ... parameters) throws XMLStreamException {
        if (!condition) {
            throw new XMLStreamException(ModelException.buildErrorMessage((String)errorMessage, (Object[])parameters), event == null ? null : event.getLocation());
        }
    }

    private static void checkEndElement(XMLEvent element, String expectedName) throws XMLStreamException {
        XmlDataImporter.check(element.isEndElement(), element, "Exptected end of \"{}\", found \"{}\"", expectedName, element);
        String elementName = element.asEndElement().getName().getLocalPart();
        XmlDataImporter.check(expectedName.equals(elementName), element, "Expected end of \"{}\" instead of \"{}\"", expectedName, elementName);
    }

    private static <T> T checkExists(T value, XMLEvent event, String errorMessage, Object ... parameters) throws XMLStreamException {
        XmlDataImporter.check(value != null, event, errorMessage, parameters);
        return value;
    }

    private static boolean isEntityReference(StartElement element) {
        Attribute reference = element.getAttributeByName(REFERENCE_ATTRIBUTE);
        return reference != null && "true".equals(reference.getValue());
    }

    private static XMLEvent nextEvent(XMLEventReader reader) throws XMLStreamException {
        try {
            XMLEvent nextEvent = reader.nextEvent();
            while (nextEvent.isCharacters() && nextEvent.asCharacters().isWhiteSpace()) {
                nextEvent = reader.nextEvent();
            }
            return nextEvent;
        }
        catch (NoSuchElementException e) {
            throw new XMLStreamException("Unexpected end of document", e);
        }
    }

    private static boolean nextEventIsStartElement(XMLEventReader reader) throws XMLStreamException {
        return XmlDataImporter.skipWhitespaces(reader).isStartElement();
    }

    private static String readCharacters(XMLEventReader reader, String endElement) throws XMLStreamException {
        StringBuilder result = new StringBuilder();
        XMLEvent event = reader.nextEvent();
        while (event != null) {
            switch (event.getEventType()) {
                case 5: {
                    break;
                }
                case 4: 
                case 12: {
                    if (event.asCharacters().isIgnorableWhiteSpace()) break;
                    result.append(event.asCharacters().getData());
                    break;
                }
                default: {
                    XmlDataImporter.checkEndElement(event, endElement);
                    return result.toString().trim();
                }
            }
            event = reader.nextEvent();
        }
        throw new XMLStreamException("Unexpected end of document");
    }

    private static XMLEvent skipWhitespaces(XMLEventReader reader) throws XMLStreamException {
        XMLEvent nextEvent = reader.peek();
        while (nextEvent != null) {
            switch (nextEvent.getEventType()) {
                case 5: {
                    break;
                }
                case 4: 
                case 12: {
                    if (nextEvent.asCharacters().isWhiteSpace()) break;
                }
                default: {
                    return nextEvent;
                }
            }
            reader.nextEvent();
            nextEvent = reader.peek();
        }
        return nextEvent;
    }

    private static DataImportException wrapRuntimeException(RuntimeException e, DataFile file, XMLEvent nextEvent) {
        return new DataImportException(e.getMessage(), file.getName(), nextEvent == null || nextEvent.getLocation() == null ? -1 : nextEvent.getLocation().getLineNumber(), nextEvent == null || nextEvent.getLocation() == null ? -1 : nextEvent.getLocation().getColumnNumber(), e);
    }

    private static DataImportException wrapStreamException(XMLStreamException e, DataFile file) {
        Location location = e.getLocation();
        return new DataImportException(e.toString(), file.getName(), location == null ? -1 : location.getLineNumber(), location == null ? -1 : (location.getColumnNumber() < 0 ? location.getCharacterOffset() : location.getColumnNumber()), e);
    }

    public XmlDataImporter() {
        this.context = new GeneratorContext();
        this.entityRegistration = new EntityRegistration(this.context);
    }

    private <T> T convert(XMLEvent element, String propertyName, String content, Class<T> type) throws XMLStreamException {
        PropertyConverter<T> converter = this.findConverter(type);
        XmlDataImporter.checkExists(converter, element, "Could not find converter for \"{}\"", propertyName);
        return converter.convert(type, content);
    }

    protected <E> void importAttribute(XMLEventReader reader, StartElement element, E entity, Map<String, ? extends Property<? super E, ?>> properties, Attribute attribute) throws XMLStreamException {
        String elementName = element.getName().getLocalPart();
        String propertyName = attribute.getName().getLocalPart();
        Property<? super E, ?> property = properties.get(propertyName);
        XmlDataImporter.checkExists(property, attribute, "Unknown property for attribute \"{}\" of \"{}\"", propertyName, elementName);
        if (property instanceof PrimitiveProperty) {
            Object value = this.convert(attribute, property.getName(), attribute.getValue(), property.getType());
            this.importPrimitiveProperty(reader, entity, (PrimitiveProperty)property, value);
        } else if (property instanceof EntityProperty) {
            EntityProperty entityProperty = (EntityProperty)property;
            List uniqueProperties = entityProperty.getTargetClass().getAllUniqueProperties();
            XmlDataImporter.check(uniqueProperties.size() == 1 && ((List)uniqueProperties.get(0)).size() == 1, attribute, "\"{}\" needs to have exactly one unique property to be referenced as attribute of \"{}\"", property, elementName);
            SingularProperty uniqueProperty = (SingularProperty)((List)uniqueProperties.get(0)).get(0);
            Object uniqueValue = this.convert(attribute, property.getName(), attribute.getValue(), uniqueProperty.getType());
            this.entityRegistration.invokeOnEntity(entityProperty.getTargetClass().getEntityClass(), uniqueProperty.getName(), uniqueValue, targetEntity -> entityProperty.setValue(entity, targetEntity));
        } else {
            throw new XMLStreamException("The property \"" + property.getName() + "\" is not singular and can't be used as attribute of \"" + elementName + '\"', attribute.getLocation());
        }
    }

    protected <E> void importElement(XMLEventReader reader, StartElement entityElement, E entity, Map<String, ? extends Property<? super E, ?>> properties, StartElement propertyElement) throws XMLStreamException {
        String propertyName = propertyElement.getName().getLocalPart();
        Property<? super E, ?> property = properties.get(propertyName);
        XmlDataImporter.checkExists(property, propertyElement, "Unknown property for child element \"{}\" of \"{}\"", propertyName, entityElement.getName().getLocalPart());
        this.importProperty(reader, propertyElement, property, entity);
    }

    protected <E, T> void importEmbeddedProperty(XMLEventReader reader, StartElement propertyElement, E entity, EmbeddedProperty<? super E, T> property) throws XMLStreamException {
        this.importProperties(reader, propertyElement, property.getEmbeddedProperties(), property.getInitializedValue(entity));
        XMLEvent endElement = reader.nextEvent();
        XmlDataImporter.checkEndElement(endElement, property.getName());
    }

    protected <E> void importEntity(XMLEventReader reader, StartElement element, EntityClass<E> classDescription, boolean reference, Consumer<E> onImport) throws XMLStreamException {
        Object entity = classDescription.newInstance();
        this.importProperties(reader, element, classDescription.getProperties(), entity);
        XMLEvent endElement = reader.nextEvent();
        XmlDataImporter.checkEndElement(endElement, classDescription.getEntityName());
        if (reference) {
            this.entityRegistration.invokeOnEntity(entity, onImport);
        } else {
            this.entityRegistration.registerEntity(entity);
            onImport.accept(entity);
        }
    }

    protected <E, T> void importEntityProperty(XMLEventReader reader, E entity, EntityProperty<E, T> property) throws XMLStreamException {
        XMLEvent nextEvent = XmlDataImporter.nextEvent(reader);
        XmlDataImporter.check(nextEvent.isStartElement(), nextEvent, "Expecting element with entity name as child of \"{}\"", property.getName());
        StartElement entityElement = nextEvent.asStartElement();
        String entityName = entityElement.getName().getLocalPart();
        EntityClass childClassDescription = XmlDataImporter.checkExists((EntityClass)this.context.getDescriptionsByName().get(entityName), entityElement, "Unknown entity type: {}", entityName);
        XmlDataImporter.check(property.getTargetClass().getEntityClass().isAssignableFrom(childClassDescription.getEntityClass()), entityElement, "Expected at least \"{}\" for \"{}\", found \"{}\"", property.getTargetClass().getEntityName(), property.getName(), childClassDescription.getEntityName());
        Consumer<Object> onImport = targetEntity -> property.setValue(entity, targetEntity);
        Property inverseProperty = property.getInverseProperty();
        if (inverseProperty instanceof PluralProperty) {
            onImport = onImport.andThen(targetEntity -> PluralPropertyContents.create(targetEntity, (PluralProperty)inverseProperty).addElement(entity));
        } else if (inverseProperty instanceof EntityProperty) {
            onImport = onImport.andThen(targetEntity -> ((EntityProperty)inverseProperty).setValue(targetEntity, entity));
        }
        this.importEntity(reader, entityElement, childClassDescription, XmlDataImporter.isEntityReference(entityElement), onImport);
        XmlDataImporter.checkEndElement(XmlDataImporter.nextEvent(reader), property.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Object> importFile(DataFile file) throws IOException, DataImportException {
        try (InputStream input = file.open();){
            XMLEventReader reader = XMLInputFactory.newFactory().createXMLEventReader(input);
            while (reader.hasNext() && !reader.peek().isStartElement()) {
                reader.next();
            }
            if (!reader.hasNext()) {
                throw new XMLStreamException("Unexpected end of document");
            }
            StartElement containerElement = XmlDataImporter.nextEvent(reader).asStartElement();
            ArrayList<Object> entities = new ArrayList<Object>();
            try {
                while (XmlDataImporter.nextEventIsStartElement(reader)) {
                    StartElement element = reader.nextEvent().asStartElement();
                    String entityName = element.getName().getLocalPart();
                    EntityClass classDescription = XmlDataImporter.checkExists((EntityClass)this.context.getDescriptionsByName().get(entityName), element, "Unsupported element: {}", entityName);
                    this.importEntity(reader, element, classDescription, false, entities::add);
                }
            }
            catch (RuntimeException e) {
                XMLEvent nextEvent = reader.peek();
                throw XmlDataImporter.wrapRuntimeException(e, file, nextEvent);
            }
            XmlDataImporter.checkEndElement(reader.nextEvent(), containerElement.getName().getLocalPart());
            XMLEvent endElement = XmlDataImporter.nextEvent(reader);
            XmlDataImporter.check(endElement.isEndDocument(), endElement, "Expected end of file, found: {}", endElement);
            reader.close();
            ArrayList<Object> arrayList = entities;
            return arrayList;
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalStateException(e);
        }
        catch (XMLStreamException e) {
            throw XmlDataImporter.wrapStreamException(e, file);
        }
    }

    protected <E, T> void importPluralProperty(XMLEventReader reader, E entity, PluralProperty<? super E, ?, T> property) throws XMLStreamException {
        PropertyConverter keyConverter;
        Class keyType;
        List embeddedProperties = property.getEmbeddedProperties();
        EntityClass targetClass = property.getValueEntityClass();
        String elementName = targetClass != null ? targetClass.getEntityName() : property.getValueClass().getSimpleName();
        Property inverseProperty = property.getInverseProperty();
        Consumer<Object> onImport = inverseProperty instanceof PluralProperty ? targetEntity -> PluralPropertyContents.create(targetEntity, (PluralProperty)inverseProperty).addElement(entity) : (inverseProperty instanceof EntityProperty ? targetEntity -> ((EntityProperty)inverseProperty).setValue(targetEntity, entity) : NOOP_CONSUMER);
        if (property instanceof MapProperty) {
            keyType = ((MapProperty)property).getKeyClass();
            keyConverter = this.findConverter(keyType);
            XmlDataImporter.checkExists(keyConverter, reader.peek(), "Could not find converter for key of \"{}\"", property);
        } else {
            keyType = null;
            keyConverter = null;
        }
        PluralPropertyContents collection = PluralPropertyContents.create(entity, property);
        int index = 0;
        while (XmlDataImporter.nextEventIsStartElement(reader)) {
            Object value;
            Object key;
            StartElement element = reader.nextEvent().asStartElement();
            String localPart = element.getName().getLocalPart();
            XmlDataImporter.check(localPart.equals(elementName), element, "Expected \"{}\", found \"{}\"", elementName, localPart);
            if (keyConverter != null) {
                Attribute keyAttribute = element.getAttributeByName(KEY_ATTRIBUTE);
                XmlDataImporter.checkExists(keyAttribute, element, "Missing key attribute for \"{}\"", property);
                key = keyConverter.convert(keyType, keyAttribute.getValue());
            } else {
                key = null;
            }
            int currentIndex = index;
            if (embeddedProperties != null) {
                value = property.newElement();
                collection.setElement(index, key, value);
                this.importProperties(reader, element, property.getEmbeddedPropertiesByName(), value);
                XmlDataImporter.checkEndElement(XmlDataImporter.nextEvent(reader), elementName);
            } else if (targetClass == null) {
                value = this.convert(element, elementName, XmlDataImporter.readCharacters(reader, elementName), property.getValueClass());
                collection.setElement(currentIndex, key, value);
                XmlDataImporter.checkEndElement(XmlDataImporter.nextEvent(reader), elementName);
            } else {
                this.importEntity(reader, element, targetClass, XmlDataImporter.isEntityReference(element), onImport.andThen(targetEntity -> collection.setElement(currentIndex, key, targetEntity)));
            }
            ++index;
        }
        XmlDataImporter.checkEndElement(reader.nextEvent(), property.getName());
    }

    protected <E, T> void importPrimitiveProperty(XMLEventReader reader, E entity, PrimitiveProperty<E, T> property) throws XMLStreamException {
        XMLEvent event = reader.peek();
        String content = XmlDataImporter.readCharacters(reader, property.getName());
        T value = this.convert(event, property.getName(), content, property.getType());
        this.importPrimitiveProperty(reader, entity, property, value);
    }

    protected <E, T> void importPrimitiveProperty(XMLEventReader reader, E entity, PrimitiveProperty<E, T> property, T value) {
        if (!(property instanceof GeneratedIdProperty)) {
            property.setValue(entity, value);
        }
    }

    protected <E> void importProperties(XMLEventReader reader, StartElement element, Map<String, ? extends Property<? super E, ?>> properties, E entity) throws XMLStreamException {
        Iterator<Attribute> attributes = element.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (attribute.getName().equals(REFERENCE_ATTRIBUTE)) continue;
            this.importAttribute(reader, element, entity, properties, attribute);
        }
        while (XmlDataImporter.nextEventIsStartElement(reader)) {
            this.importElement(reader, element, entity, properties, reader.nextEvent().asStartElement());
        }
    }

    protected <E, T> void importProperty(XMLEventReader reader, StartElement element, Property<? super E, T> property, E entity) throws XMLStreamException {
        if (property instanceof PluralProperty) {
            this.importPluralProperty(reader, entity, (PluralProperty)property);
        } else if (property instanceof EmbeddedProperty) {
            this.importEmbeddedProperty(reader, element, entity, (EmbeddedProperty)property);
        } else if (property instanceof EntityProperty) {
            this.importEntityProperty(reader, entity, (EntityProperty)property);
        } else if (property instanceof PrimitiveProperty) {
            this.importPrimitiveProperty(reader, entity, (PrimitiveProperty)property);
        }
    }

    @Generated
    public XmlDataImporter(GeneratorContext context, EntityRegistration entityRegistration) {
        this.context = context;
        this.entityRegistration = entityRegistration;
    }
}

