/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.provider;

import java.util.Properties;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.dialect.H2Dialect;
import org.fastnate.generator.dialect.MsSqlDialect;
import org.fastnate.generator.dialect.MySqlDialect;
import org.fastnate.generator.dialect.OracleDialect;
import org.fastnate.generator.dialect.PostgresDialect;
import org.fastnate.generator.provider.JpaProvider;

public class HibernateProvider
implements JpaProvider {
    private static Class<? extends GeneratorDialect> getGeneratorDialectFromConnectionDriver(Properties settings) {
        String connectionDriver = settings.getProperty("hibernate.connection.driver_class");
        if (connectionDriver != null) {
            if (connectionDriver.contains("postgresql")) {
                return PostgresDialect.class;
            }
            if (connectionDriver.contains("mysql")) {
                return MySqlDialect.class;
            }
            if (connectionDriver.contains("sqlserver")) {
                return MsSqlDialect.class;
            }
            if (connectionDriver.contains(".h2.")) {
                return H2Dialect.class;
            }
            if (connectionDriver.contains("oracle")) {
                return OracleDialect.class;
            }
        }
        return null;
    }

    private static Class<? extends GeneratorDialect> getGeneratorDialectFromConnectionUrl(Properties settings) {
        String connectionUrl = settings.getProperty("hibernate.connection.url");
        if (connectionUrl != null) {
            if (connectionUrl.contains(":oracle:")) {
                return OracleDialect.class;
            }
            if (connectionUrl.contains(":postgresql:")) {
                return PostgresDialect.class;
            }
            if (connectionUrl.contains(":mysql:")) {
                return MySqlDialect.class;
            }
            if (connectionUrl.contains(":sqlserver:")) {
                return MsSqlDialect.class;
            }
            if (connectionUrl.contains(":h2:")) {
                return H2Dialect.class;
            }
        }
        return null;
    }

    private static Class<? extends GeneratorDialect> getGeneratorDialectFromHibernateDialect(Properties settings) {
        String hibernateDialect = settings.getProperty("hibernate.dialect");
        if (hibernateDialect != null) {
            if (hibernateDialect.contains("Oracle")) {
                return OracleDialect.class;
            }
            if (hibernateDialect.contains("PostgreSQL")) {
                return PostgresDialect.class;
            }
            if (hibernateDialect.contains("MySQL")) {
                return MySqlDialect.class;
            }
            if (hibernateDialect.contains("SQLServer")) {
                return MsSqlDialect.class;
            }
            if (hibernateDialect.contains("H2Dialect")) {
                return H2Dialect.class;
            }
        }
        return null;
    }

    @Override
    public String getDefaultGeneratorTable() {
        return "hibernate_sequences";
    }

    @Override
    public String getDefaultGeneratorTablePkColumnName() {
        return "sequence_name";
    }

    @Override
    public String getDefaultGeneratorTablePkColumnValue() {
        return "";
    }

    @Override
    public String getDefaultGeneratorTableValueColumnName() {
        return "next_val";
    }

    @Override
    public String getDefaultSequence() {
        return "hibernate_sequence";
    }

    @Override
    public void initialize(Properties settings) {
        if (!settings.containsKey("fastnate.generator.dialect")) {
            Class<? extends GeneratorDialect> dialect = HibernateProvider.getGeneratorDialectFromHibernateDialect(settings);
            if (dialect == null && (dialect = HibernateProvider.getGeneratorDialectFromConnectionUrl(settings)) == null) {
                dialect = HibernateProvider.getGeneratorDialectFromConnectionDriver(settings);
            }
            if (dialect != null) {
                settings.setProperty("fastnate.generator.dialect", dialect.getName());
            }
        }
        if (!settings.containsKey("fastnate.generator.log.statements") && settings.containsKey("hibernate.show_sql")) {
            settings.setProperty("fastnate.generator.log.statements", settings.getProperty("hibernate.show_sql"));
        }
    }

    @Override
    public boolean isJoinedDiscriminatorNeeded() {
        return false;
    }
}

