/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.statements;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fastnate.generator.context.ContextModelListener;
import org.fastnate.generator.context.DefaultContextModelListener;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.context.IdGenerator;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.context.SequenceIdGenerator;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.AbstractStatementsWriter;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.PrimitiveColumnExpression;
import org.fastnate.generator.statements.TableStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectedStatementsWriter
extends AbstractStatementsWriter {
    private static final Logger log = LoggerFactory.getLogger(ConnectedStatementsWriter.class);
    public static final String MAX_BATCH_SIZE_KEY = "fastnate.generator.max.batch";
    public static final String LOG_STATEMENTS_KEY = "fastnate.generator.log.statements";
    private static final long MILLISECONDS_BETWEEN_LOG_MESSAGES = 60000L;
    private final GeneratorContext context;
    private final ContextModelListener contextListener;
    private final Connection connection;
    private final boolean batchSupported;
    private final boolean logStatements;
    private final int maxBatchSize;
    private final Statement plainStatement;
    private final List<PreparedInsertStatement> preparedStatements = new ArrayList<PreparedInsertStatement>();
    private final Map<GeneratorTable, List<PreparedInsertStatement>> availablePreparedStatements = new HashMap<GeneratorTable, List<PreparedInsertStatement>>();
    private int batchCount;
    private long lastLogTime;
    private long statementsCount;

    public ConnectedStatementsWriter(Connection connection, GeneratorContext context) throws SQLException {
        this.connection = connection;
        this.context = context;
        this.batchSupported = connection.getMetaData().supportsBatchUpdates();
        this.logStatements = Boolean.parseBoolean(context.getSettings().getProperty(LOG_STATEMENTS_KEY, "false"));
        this.maxBatchSize = Integer.parseInt(context.getSettings().getProperty(MAX_BATCH_SIZE_KEY, "100"));
        this.plainStatement = connection.createStatement();
        this.contextListener = new ContextListener(context, this.plainStatement, this.preparedStatements, this.availablePreparedStatements);
        context.addContextModelListener(this.contextListener);
    }

    private void checkUpdate(int updatedRows, String sql) {
        if (updatedRows != 1) {
            throw new IllegalStateException(String.valueOf(updatedRows == 0 ? "No row created for " : "More than one rows created for ") + sql);
        }
        ++this.statementsCount;
    }

    @Override
    public void close() throws IOException {
        this.context.removeContextModelListener(this.contextListener);
        this.closeBatch();
        log.info("{} SQL statements successfully executed", (Object)this.statementsCount);
        try {
            this.plainStatement.close();
            for (PreparedInsertStatement stmt : this.preparedStatements) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void closeBatch() throws IOException {
        if (this.batchCount > 0) {
            try {
                try {
                    this.plainStatement.executeBatch();
                    this.statementsCount += (long)this.batchCount;
                }
                catch (SQLException e) {
                    throw new IOException("Could not execute statements: " + e, e);
                }
            }
            finally {
                this.batchCount = 0;
            }
        }
    }

    @Override
    public TableStatement createInsertStatement(GeneratorDialect dialect, GeneratorTable table) {
        PreparedInsertStatement insertStatement;
        List<PreparedInsertStatement> availableStatements = this.availablePreparedStatements.get(table);
        if (availableStatements == null) {
            availableStatements = new ArrayList<PreparedInsertStatement>();
            this.availablePreparedStatements.put(table, availableStatements);
        }
        if (availableStatements.isEmpty()) {
            try {
                insertStatement = new PreparedInsertStatement(dialect, this.connection, table);
                this.preparedStatements.add(insertStatement);
            }
            catch (SQLException e) {
                throw new IllegalStateException("Can't generate prepared statement for " + table.getName(), e);
            }
        } else {
            insertStatement = availableStatements.remove(availableStatements.size() - 1);
            insertStatement.reset();
        }
        return insertStatement;
    }

    @Override
    public void flush() throws IOException {
        this.closeBatch();
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            throw new IOException("Could not commit transaction: " + e, e);
        }
    }

    @Override
    public void writePlainStatement(GeneratorDialect dialect, String sql) throws IOException {
        this.writePlainStatement(sql);
    }

    private void writePlainStatement(String sql) throws IOException {
        try {
            this.closeBatch();
            if (this.logStatements) {
                log.info(sql);
            }
            this.plainStatement.executeUpdate(sql);
            ++this.statementsCount;
        }
        catch (SQLException e) {
            throw new IOException("Could not execute statement: " + sql, e);
        }
    }

    @Override
    public void writeStatement(EntityStatement stmt) throws IOException {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastLogTime >= 60000L) {
            this.lastLogTime = currentTime;
            if (this.statementsCount > 1L) {
                log.info("{} SQL statements executed", (Object)this.statementsCount);
            }
        }
        if (stmt instanceof PreparedInsertStatement) {
            PreparedInsertStatement insert = (PreparedInsertStatement)stmt;
            if (insert.isPlainExpressionAvailable()) {
                this.writeTableStatement(insert.toSql());
            } else {
                this.closeBatch();
                String sql = insert.getSql();
                if (this.logStatements) {
                    log.info(insert.toSql());
                }
                try {
                    this.checkUpdate(insert.executeUpdate(), sql);
                }
                catch (SQLException e) {
                    throw new IOException("Could not execute statement: " + sql, e);
                }
            }
            if (insert.getTable().getColumns().size() > insert.getColumnCount()) {
                this.preparedStatements.remove(insert);
                try {
                    insert.close();
                }
                catch (SQLException e) {
                    throw new IOException("Could not close prepared statement: " + e, e);
                }
            } else {
                this.availablePreparedStatements.get(insert.getTable()).add(insert);
            }
        } else if (stmt instanceof TableStatement) {
            this.writeTableStatement(stmt.toSql());
        } else {
            this.writePlainStatement(stmt.toSql());
        }
    }

    private void writeTableStatement(String sql) throws IOException {
        if (this.logStatements) {
            log.info(sql);
        }
        try {
            if (this.batchSupported && this.maxBatchSize > 1) {
                this.plainStatement.addBatch(sql);
                if (++this.batchCount > this.maxBatchSize) {
                    this.closeBatch();
                }
            } else {
                this.checkUpdate(this.plainStatement.executeUpdate(sql), sql);
            }
        }
        catch (SQLException e) {
            throw new IOException("Could not execute statement: " + sql, e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public long getStatementsCount() {
        return this.statementsCount;
    }

    private static final class ContextListener
    extends DefaultContextModelListener {
        private final GeneratorContext context;
        private final Statement plainStatement;
        private final List<PreparedInsertStatement> preparedStatements;
        private final Map<GeneratorTable, List<PreparedInsertStatement>> availablePreparedStatements;

        @Override
        public void foundColumn(GeneratorColumn column) {
            List<PreparedInsertStatement> statements = this.availablePreparedStatements.get(column.getTable());
            if (statements != null) {
                int i = statements.size() - 1;
                while (i >= 0) {
                    try {
                        PreparedInsertStatement statement = statements.remove(i);
                        this.preparedStatements.remove(statement);
                        statement.close();
                    }
                    catch (SQLException e) {
                        throw new ModelException("Could not close statement after new column was added", e);
                    }
                    --i;
                }
            }
        }

        @Override
        public void foundGenerator(IdGenerator generator) {
            block17: {
                if (!this.context.isWriteRelativeIds()) {
                    String sql = generator.getExpression(null, null, generator.getCurrentValue(), false);
                    sql = sql.matches("(SELECT\\W.*)") ? sql.substring(1, sql.length() - 1) : "SELECT (" + sql + ") currentValue " + this.context.getDialect().getOptionalTable();
                    try {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (ResultSet resultSet = this.plainStatement.executeQuery(sql);){
                            if (resultSet.next()) {
                                SequenceIdGenerator sequence;
                                long currentValue = resultSet.getLong(1);
                                if (resultSet.wasNull()) {
                                    return;
                                }
                                if (generator instanceof SequenceIdGenerator && (sequence = (SequenceIdGenerator)generator).getInitialValue() - (long)sequence.getAllocationSize() == currentValue) {
                                    return;
                                }
                                generator.setCurrentValue(currentValue);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (SQLException e) {
                        if (generator instanceof SequenceIdGenerator) break block17;
                        throw new IllegalStateException("Can't initialize generator with " + sql, e);
                    }
                }
            }
        }

        public ContextListener(GeneratorContext context, Statement plainStatement, List<PreparedInsertStatement> preparedStatements, Map<GeneratorTable, List<PreparedInsertStatement>> availablePreparedStatements) {
            this.context = context;
            this.plainStatement = plainStatement;
            this.preparedStatements = preparedStatements;
            this.availablePreparedStatements = availablePreparedStatements;
        }
    }

    private static final class PreparedInsertStatement
    extends AbstractStatementsWriter.InsertStatement {
        private final PreparedStatement statement;
        private final int columnCount;
        private final String sql;
        private final BitSet availableColumns;
        private final int[] parameterIndices;

        PreparedInsertStatement(GeneratorDialect dialect, Connection connection, GeneratorTable table) throws SQLException {
            super(dialect, table);
            StringBuilder sqlBuilder = new StringBuilder("INSERT INTO ").append(this.getTable().getName()).append(' ');
            Collection<GeneratorColumn> columns = table.getColumns().values();
            this.columnCount = columns.size();
            this.parameterIndices = new int[this.columnCount];
            int parameterCount = 0;
            for (GeneratorColumn column : columns) {
                if (column.isAutoGenerated()) continue;
                sqlBuilder.append(parameterCount > 0 ? (char)',' : '(');
                sqlBuilder.append(column.getName());
                this.parameterIndices[column.getIndex()] = ++parameterCount;
            }
            if (parameterCount == 0) {
                sqlBuilder.append(dialect.getEmptyValuesExpression());
            } else {
                sqlBuilder.append(") VALUES (");
                sqlBuilder.append('?');
                while (--parameterCount > 0) {
                    sqlBuilder.append(",?");
                }
                sqlBuilder.append(')');
            }
            this.sql = sqlBuilder.toString();
            this.statement = connection.prepareStatement(this.sql);
            this.availableColumns = new BitSet(this.columnCount);
        }

        public void close() throws SQLException {
            this.statement.close();
        }

        public int executeUpdate() throws SQLException {
            if (this.availableColumns.cardinality() != this.columnCount) {
                int i = 0;
                while (i < this.columnCount) {
                    int parameterIndex;
                    if (!this.availableColumns.get(i) && (parameterIndex = this.parameterIndices[i]) > 0) {
                        this.statement.setObject(parameterIndex, null);
                    }
                    ++i;
                }
            }
            return this.statement.executeUpdate();
        }

        @Override
        public void reset() {
            this.availableColumns.clear();
            super.reset();
        }

        @Override
        public void setColumnValue(GeneratorColumn column, ColumnExpression expression) {
            super.setColumnValue(column, expression);
            if (!this.isPlainExpressionAvailable()) {
                try {
                    int index = column.getIndex();
                    this.availableColumns.set(index);
                    int parameterIndex = this.parameterIndices[index];
                    if (parameterIndex <= 0) {
                        throw new IllegalArgumentException("Can't set auto generated column " + column.getName());
                    }
                    this.statement.setObject(parameterIndex, ((PrimitiveColumnExpression)expression).getValue());
                }
                catch (SQLException e) {
                    throw new IllegalArgumentException("Can't set " + column + " to " + expression + " in " + this.sql, e);
                }
            }
        }

        public PreparedStatement getStatement() {
            return this.statement;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public String getSql() {
            return this.sql;
        }
    }
}

