/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class ClassUtil {
    private static <I> Type getActualTypeArgument(Class<? extends I> instanceClass, Class<I> superClass, int argumentIndex) {
        if (instanceClass == superClass) {
            return instanceClass.getTypeParameters()[argumentIndex];
        }
        ArrayList<Type> parents = new ArrayList<Type>();
        parents.add(instanceClass.getGenericSuperclass());
        parents.addAll(Arrays.asList(instanceClass.getGenericInterfaces()));
        for (Type parentType : parents) {
            Class parentClass;
            Class clazz = parentClass = parentType instanceof ParameterizedType ? (Class)((ParameterizedType)parentType).getRawType() : (Class)parentType;
            if (superClass.equals(parentClass)) {
                return ((ParameterizedType)parentType).getActualTypeArguments()[argumentIndex];
            }
            if (parentClass == null || !superClass.isAssignableFrom(parentClass)) continue;
            Type type = ClassUtil.getActualTypeArgument(parentClass.asSubclass(superClass), superClass, argumentIndex);
            if (type instanceof Class) {
                return type;
            }
            if (!(type instanceof TypeVariable)) continue;
            return ((ParameterizedType)parentType).getActualTypeArguments()[Arrays.asList(parentClass.getTypeParameters()).indexOf(type)];
        }
        return null;
    }

    public static <T, I> Class<T> getActualTypeBinding(Class<? extends I> instanceClass, Class<I> superClass, int argumentIndex) {
        Type type = ClassUtil.getActualTypeArgument(instanceClass, superClass, argumentIndex);
        while (!(type instanceof Class)) {
            if (type instanceof WildcardType) {
                type = ((WildcardType)type).getUpperBounds()[0];
                continue;
            }
            if (type instanceof TypeVariable) {
                type = ((TypeVariable)type).getBounds()[0];
                continue;
            }
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
                continue;
            }
            throw new NoSuchElementException("Can't find binding for the " + argumentIndex + ". argument of " + superClass + " in " + instanceClass);
        }
        return (Class)type;
    }

    public static <T, I> Class<T> getActualTypeBinding(Class<? extends I> instanceClass, Class<I> declaringClass, Type attributeType) {
        Type rawType;
        Type bound;
        if (attributeType instanceof Class) {
            return (Class)attributeType;
        }
        if (attributeType instanceof TypeVariable) {
            String name = ((TypeVariable)attributeType).getName();
            TypeVariable<Class<I>>[] typeParameters = declaringClass.getTypeParameters();
            int i = 0;
            while (i < typeParameters.length) {
                TypeVariable<Class<I>> variable = typeParameters[i];
                if (variable.getName().equals(name)) {
                    return ClassUtil.getActualTypeBinding(instanceClass, declaringClass, i);
                }
                ++i;
            }
        }
        if (attributeType instanceof WildcardType && (bound = ((WildcardType)attributeType).getUpperBounds()[0]) != attributeType) {
            return ClassUtil.getActualTypeBinding(instanceClass, declaringClass, bound);
        }
        if (attributeType instanceof ParameterizedType && !(rawType = ((ParameterizedType)attributeType).getRawType()).equals(attributeType)) {
            return ClassUtil.getActualTypeBinding(instanceClass, declaringClass, rawType);
        }
        throw new NoSuchElementException("Can't find binding for " + attributeType + " declared in " + declaringClass + " and implented in " + instanceClass);
    }

    public static String getCallerMethod() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        int i = 2;
        while (i < stackTrace.length) {
            String methodName = stackTrace[i].getMethodName();
            if (methodName.indexOf(36) < 0) {
                return methodName;
            }
            ++i;
        }
        return stackTrace[1].getMethodName();
    }

    public static String getCallerMethod(Class<?> callerClass) {
        String callerClassName = callerClass.getName();
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        int i = 2;
        while (i < stackTrace.length) {
            String methodName = stackTrace[i].getMethodName();
            if (methodName.indexOf(36) < 0 && callerClassName.equals(stackTrace[i].getClassName())) {
                return methodName;
            }
            ++i;
        }
        return stackTrace[1].getMethodName();
    }

    private ClassUtil() {
    }
}

