/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.persistence.Column;
import javax.validation.constraints.NotNull;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.converter.BooleanConverter;
import org.fastnate.generator.converter.NumberConverter;
import org.fastnate.generator.converter.StringConverter;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;
import org.fastnate.generator.statements.TableStatement;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.AnyMetaDefs;
import org.hibernate.annotations.MetaValue;

public class AnyMapping<T> {
    private static final Map<String, Supplier<? extends ValueConverter<?>>> META_TYPES = new HashMap();
    private final GeneratorColumn column;
    private final Map<Class<?>, ColumnExpression> anyClasses = new HashMap();

    static {
        META_TYPES.put("boolean", BooleanConverter::new);
        META_TYPES.put("byte", () -> new NumberConverter(Byte.class));
        META_TYPES.put("short", () -> new NumberConverter(Short.class));
        META_TYPES.put("integer", () -> new NumberConverter(Integer.class));
        META_TYPES.put("long", () -> new NumberConverter(Long.class));
        META_TYPES.put("float", () -> new NumberConverter(Float.class));
        META_TYPES.put("double", () -> new NumberConverter(Double.class));
    }

    private static AnyMetaDef findElementMetaDef(AnnotatedElement element, String metaDefName) {
        AnyMetaDef metaDef = element.getAnnotation(AnyMetaDef.class);
        if (metaDef != null && metaDefName.equals(metaDef.name())) {
            return metaDef;
        }
        AnyMetaDefs metaDefs = element.getAnnotation(AnyMetaDefs.class);
        if (metaDefs != null) {
            AnyMetaDef[] anyMetaDefArray = metaDefs.value();
            int n = anyMetaDefArray.length;
            int n2 = 0;
            while (n2 < n) {
                AnyMetaDef metaDefsValue = anyMetaDefArray[n2];
                if (metaDefName.equals(metaDefsValue.name())) {
                    return metaDefsValue;
                }
                ++n2;
            }
        }
        return null;
    }

    public AnyMapping(GeneratorContext context, AttributeAccessor attribute, GeneratorTable containerTabble, Column typeColumn, String metaDefName) {
        this.column = containerTabble.resolveColumn(typeColumn.name());
        this.fillMetaDefs(attribute, typeColumn, metaDefName, context);
    }

    private void fillMetaDefs(AttributeAccessor attribute, Column typeColumn, String metaDefName, GeneratorContext context) {
        AnyMetaDef metaDef;
        if (metaDefName != null && metaDefName.length() > 0) {
            metaDef = this.findGlobalMetaDef(attribute, metaDefName);
            ModelException.mustExist(metaDef, "Can't find AnyMetaDef with name {} for {} in the class hierarchy", metaDefName, attribute);
        } else {
            metaDef = attribute.getAnnotation(AnyMetaDef.class);
            ModelException.mustExist(metaDef, "Missing AnyMetaDef annotation for {}", attribute);
        }
        ValueConverter converter = META_TYPES.getOrDefault(metaDef.metaType(), () -> new StringConverter(typeColumn, !attribute.isAnnotationPresent(NotNull.class))).get();
        HashSet<String> duplicates = new HashSet<String>();
        MetaValue[] metaValueArray = metaDef.metaValues();
        int n = metaValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetaValue metaValue = metaValueArray[n2];
            ModelException.test(this.anyClasses.put(metaValue.targetEntity(), converter.getExpression(metaValue.value(), context)) == null, "The class {} is defined twice for AnyMetaDef assigned to {}", metaValue.targetEntity(), attribute);
            ModelException.test(duplicates.add(metaValue.value()), "The value {} is defined twice for AnyMetaDef assigned to {}", metaValue.value(), attribute);
            ++n2;
        }
    }

    private ColumnExpression findDesc(T entity) {
        ColumnExpression desc = this.anyClasses.get(entity.getClass());
        ModelException.mustExist(desc, "Missing AnyMetaDef for {}", entity.getClass());
        return desc;
    }

    private AnyMetaDef findGlobalMetaDef(AttributeAccessor attribute, String metaDefName) {
        AnyMetaDef metaDef = AnyMapping.findElementMetaDef(attribute, metaDefName);
        if (metaDef != null) {
            return metaDef;
        }
        metaDef = this.findMetaDefInClassHierarchy(attribute.getDeclaringClass(), metaDefName);
        if (metaDef != null) {
            return metaDef;
        }
        return this.findMetaDefInClassHierarchy(attribute.getType(), metaDefName);
    }

    private AnyMetaDef findMetaDefInClassHierarchy(Class<?> entityClass, String metaDefName) {
        if (entityClass == null || entityClass == Object.class) {
            return null;
        }
        AnyMetaDef metaDef = AnyMapping.findElementMetaDef(entityClass, metaDefName);
        if (metaDef != null) {
            return metaDef;
        }
        metaDef = AnyMapping.findElementMetaDef(entityClass.getPackage(), metaDefName);
        if (metaDef != null) {
            return metaDef;
        }
        Class<?>[] classArray = entityClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interf = classArray[n2];
            metaDef = this.findMetaDefInClassHierarchy(interf, metaDefName);
            if (metaDef != null) {
                return metaDef;
            }
            ++n2;
        }
        metaDef = this.findMetaDefInClassHierarchy(entityClass.getSuperclass(), metaDefName);
        if (metaDef != null) {
            return metaDef;
        }
        return Stream.concat(Stream.of(entityClass.getDeclaredFields()), Stream.of(entityClass.getDeclaredMethods())).map(element -> AnyMapping.findElementMetaDef(element, metaDefName)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public String getPredicate(T value) {
        if (value == null) {
            return String.valueOf(this.column.getName()) + "IS NULL";
        }
        return String.valueOf(this.column.getName()) + " = " + this.findDesc(value);
    }

    public void setColumnValue(TableStatement statement, T value) {
        if (value == null) {
            statement.setColumnValue(this.column, PrimitiveColumnExpression.NULL);
        }
        statement.setColumnValue(this.column, this.findDesc(value));
    }
}

