/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.Access;
import javax.persistence.AssociationOverride;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import org.fastnate.generator.context.AccessStyle;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.statements.StatementsWriter;
import org.fastnate.generator.statements.TableStatement;

public class EmbeddedProperty<E, T>
extends Property<E, T> {
    private final Map<String, Property<? super T, ?>> embeddedProperties = new TreeMap();
    private final boolean id;

    public EmbeddedProperty(EntityClass<?> entityClass, AttributeAccessor attribute) {
        super(attribute);
        this.id = attribute.isAnnotationPresent(EmbeddedId.class);
        Class<?> type = attribute.getType();
        if (!type.isAnnotationPresent(Embeddable.class)) {
            throw new IllegalArgumentException(attribute + " does reference " + type + " which is not embeddable.");
        }
        Access accessType = type.getAnnotation(Access.class);
        AccessStyle accessStyle = accessType != null ? AccessStyle.getStyle(accessType.value()) : attribute.getAccessStyle();
        Map<String, AttributeOverride> attributeOverrides = EntityClass.getAttributeOverrides(attribute.getElement());
        Map<String, AssociationOverride> accociationOverrides = EntityClass.getAccociationOverrides(attribute.getElement());
        Iterator<AttributeAccessor> iterator = accessStyle.getDeclaredAttributes(type, type).iterator();
        while (iterator.hasNext()) {
            AttributeAccessor field;
            AttributeOverride attrOveride = attributeOverrides.get((field = iterator.next()).getName());
            Property property = entityClass.buildProperty(field, attrOveride != null ? attrOveride.column() : field.getAnnotation(Column.class), accociationOverrides.get(field.getName()));
            if (property == null) continue;
            this.embeddedProperties.put(field.getName(), property);
        }
    }

    @Override
    public void addInsertExpression(TableStatement statement, E entity) {
        Object value = this.getValue(entity);
        if (value != null) {
            for (Property<T, ?> property : this.embeddedProperties.values()) {
                property.addInsertExpression(statement, value);
            }
        } else {
            this.failIfRequired(entity);
        }
    }

    @Override
    public void createPostInsertStatements(StatementsWriter writer, E entity) throws IOException {
        Object value = this.getValue(entity);
        for (Property<T, ?> property : this.embeddedProperties.values()) {
            property.createPostInsertStatements(writer, value);
        }
    }

    @Override
    public void createPreInsertStatements(StatementsWriter writer, E entity) throws IOException {
        Object value = this.getValue(entity);
        for (Property<T, ?> property : this.embeddedProperties.values()) {
            property.createPreInsertStatements(writer, value);
        }
    }

    @Override
    public Collection<?> findReferencedEntities(E entity) {
        Object value = this.getValue(entity);
        HashSet result = new HashSet();
        for (Property<T, ?> property : this.embeddedProperties.values()) {
            result.addAll(property.findReferencedEntities(value));
        }
        return result;
    }

    @Override
    public String getPredicate(E entity) {
        if (this.embeddedProperties.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder().append('(');
        Object value = this.getValue(entity);
        for (Property<T, ?> property : this.embeddedProperties.values()) {
            if (result.length() > 1) {
                result.append(" AND ");
            }
            result.append(property.getPredicate(value));
        }
        return result.append(")").toString();
    }

    @Override
    public boolean isRequired() {
        if (this.id) {
            return true;
        }
        for (Property<T, ?> property : this.embeddedProperties.values()) {
            if (!property.isRequired()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTableColumn() {
        return true;
    }

    public Map<String, Property<? super T, ?>> getEmbeddedProperties() {
        return this.embeddedProperties;
    }

    public boolean isId() {
        return this.id;
    }
}

