/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.IOException;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.IdGenerator;
import org.fastnate.generator.context.PrimitiveProperty;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PlainColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;
import org.fastnate.generator.statements.StatementsWriter;
import org.fastnate.generator.statements.TableStatement;

public class GeneratedIdProperty<E>
extends PrimitiveProperty<E, Number> {
    private static final long UNKOWN_ID_MARKER = -1L;
    private final boolean absoluteIds;
    private final boolean primitive;
    private final Class<? extends Number> type;
    private final EntityClass<E> entityClass;
    private final IdGenerator generator;

    public GeneratedIdProperty(EntityClass<E> entityClass, AttributeAccessor attribute, Column column) {
        super(entityClass.getContext(), entityClass.getTable(), attribute, column, entityClass.getContext().isWriteRelativeIds() || !entityClass.getContext().getDialect().isSettingIdentityAllowed());
        this.entityClass = entityClass;
        this.absoluteIds = !this.getColumn().isAutoGenerated();
        this.type = attribute.getType();
        this.primitive = this.type.isPrimitive();
        this.generator = entityClass.getContext().getGenerator(attribute.getAnnotation(GeneratedValue.class), this.getTable(), this.getColumn());
    }

    @Override
    public void addInsertExpression(TableStatement statement, E entity) {
        this.ensureIsNew(entity);
        if (this.absoluteIds) {
            Number id = this.generator.createNextValue(this.type);
            this.setValue(entity, id);
            statement.setColumnValue(this.getColumn(), PrimitiveColumnExpression.create(id, this.getDialect()));
        } else if (!this.generator.isPostIncrement()) {
            Number id = this.generator.createNextValue(this.type);
            this.setValue(entity, id);
            this.generator.addNextValue(statement, this.getColumn(), id);
        }
    }

    @Override
    public void createPreInsertStatements(StatementsWriter writer, E entity) throws IOException {
        if (!this.absoluteIds) {
            this.generator.createPreInsertStatements(writer);
        }
    }

    private void ensureIsNew(E entity) {
        if (!this.isNew(entity)) {
            throw new IllegalArgumentException("Tried to create entity twice: " + entity);
        }
    }

    @Override
    public ColumnExpression getExpression(E entity, boolean whereExpression) {
        Number targetId = (Number)this.getValue(entity);
        if (targetId == null) {
            return null;
        }
        if (targetId.longValue() == -1L) {
            throw new IllegalArgumentException("Entity must be referenced by an unique property: " + entity);
        }
        if (targetId.longValue() < 0L) {
            return PrimitiveColumnExpression.create(-2L - targetId.longValue(), this.getDialect());
        }
        if (this.absoluteIds) {
            return PrimitiveColumnExpression.create(targetId, this.getDialect());
        }
        return new PlainColumnExpression(this.generator.getExpression(this.getTable(), this.getColumn(), targetId, whereExpression));
    }

    public boolean isNew(E entity) {
        Number id = (Number)this.getValue(entity);
        return id == null || this.primitive && id.longValue() == 0L;
    }

    public boolean isReference(E entity) {
        Number id = (Number)this.getValue(entity);
        return id != null && id.longValue() < 0L;
    }

    public void markReference(E entity) {
        if (this.isNew(entity)) {
            this.setValue(entity, -1L);
        }
    }

    public void markReference(E entity, long id) {
        if (this.isNew(entity)) {
            this.setValue(entity, -2L - id);
        }
    }

    public void postInsert(E entity) {
        if (!this.absoluteIds && this.generator.isPostIncrement()) {
            this.setValue(entity, this.generator.createNextValue(this.type));
        }
    }

    public boolean isAbsoluteIds() {
        return this.absoluteIds;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public Class<? extends Number> getType() {
        return this.type;
    }

    public EntityClass<E> getEntityClass() {
        return this.entityClass;
    }

    public IdGenerator getGenerator() {
        return this.generator;
    }
}

