/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.util.LinkedHashMap;
import java.util.Map;
import org.fastnate.generator.context.ContextModelListener;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorContext;

public class GeneratorTable {
    private final int index;
    private final String name;
    private final GeneratorContext context;
    private final Map<String, GeneratorColumn> columns = new LinkedHashMap<String, GeneratorColumn>();

    public GeneratorColumn resolveColumn(String columnName) {
        return this.resolveColumn(columnName, false);
    }

    public GeneratorColumn resolveColumn(String columnName, boolean autoGenerated) {
        GeneratorColumn column = this.columns.get(columnName);
        if (column == null) {
            column = new GeneratorColumn(this, this.columns.size(), columnName, autoGenerated);
            this.columns.put(columnName, column);
            this.context.fireContextObjectAdded(ContextModelListener::foundColumn, column);
        }
        return column;
    }

    public String toString() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    public Map<String, GeneratorColumn> getColumns() {
        return this.columns;
    }

    public GeneratorTable(int index, String name, GeneratorContext context) {
        this.index = index;
        this.name = name;
        this.context = context;
    }
}

