/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.StatementsWriter;
import org.fastnate.generator.statements.TableStatement;

public abstract class Property<E, T> {
    private final AttributeAccessor attribute;

    protected Property(AttributeAccessor attribute) {
        this.attribute = attribute;
    }

    public void addInsertExpression(TableStatement statement, E entity) {
    }

    public void createPostInsertStatements(StatementsWriter writer, E entity) throws IOException {
    }

    public void createPreInsertStatements(StatementsWriter writer, E entity) throws IOException {
    }

    protected void failIfRequired(E entity) {
        if (this.isRequired()) {
            try {
                throw new IllegalArgumentException("Required property " + this + " was not set for " + entity.toString());
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Required property " + this + " was not set");
            }
        }
    }

    public Collection<?> findReferencedEntities(E entity) {
        return Collections.emptySet();
    }

    public void generatePendingStatements(StatementsWriter writer, E entity, Object writtenEntity, Object ... arguments) throws IOException {
    }

    public ColumnExpression getExpression(E entity, boolean whereExpression) {
        return null;
    }

    public String getName() {
        return this.attribute.getName();
    }

    public String getPredicate(E entity) {
        return null;
    }

    public T getValue(E entity) {
        return this.attribute.getValue(entity);
    }

    public boolean isRequired() {
        return false;
    }

    public abstract boolean isTableColumn();

    protected void setValue(E entity, T value) {
        this.attribute.setValue(entity, value);
    }

    public String toString() {
        return this.attribute.getName();
    }

    public AttributeAccessor getAttribute() {
        return this.attribute;
    }
}

