/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.statements;

import java.io.Closeable;
import java.io.IOException;
import org.fastnate.generator.context.DefaultContextModelListener;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.EntityStatement;
import org.fastnate.generator.statements.TableStatement;

public interface StatementsWriter
extends Closeable {
    public TableStatement createInsertStatement(GeneratorDialect var1, GeneratorTable var2);

    public EntityStatement createPlainStatement(GeneratorDialect var1, String var2);

    public TableStatement createUpdateStatement(GeneratorDialect var1, GeneratorTable var2, GeneratorColumn var3, ColumnExpression var4);

    public void flush() throws IOException;

    default public void truncateTables(final GeneratorContext context) {
        DefaultContextModelListener truncater = new DefaultContextModelListener(){

            @Override
            public void foundTable(GeneratorTable table) {
                try {
                    context.getDialect().truncateTable(StatementsWriter.this, table);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        for (GeneratorTable table : context.getTables().values()) {
            truncater.foundTable(table);
        }
        context.addContextModelListener(truncater);
    }

    public void writeComment(String var1) throws IOException;

    default public void writePlainStatement(GeneratorDialect dialect, String sql) throws IOException {
        this.writeStatement(this.createPlainStatement(dialect, sql));
    }

    public void writeSectionSeparator() throws IOException;

    public void writeStatement(EntityStatement var1) throws IOException;
}

