/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.persistence.AccessType;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.ModelException;
import org.fastnate.util.ClassUtil;
import org.hibernate.annotations.Formula;

public enum AccessStyle {
    FIELD{

        @Override
        public <E> Iterable<AttributeAccessor> getDeclaredAttributes(Class<E> inspectedClass, Class<? extends E> implementationClass) {
            ArrayList<AttributeAccessor> result = new ArrayList<AttributeAccessor>();
            Field[] fieldArray = inspectedClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!Modifier.isStatic(field.getModifiers()) && !field.isSynthetic()) {
                    result.add(new Accessor(implementationClass, field));
                }
                ++n2;
            }
            return result;
        }

        final class Accessor
        implements AttributeAccessor {
            private final Class<?> implementationClass;
            private final Field field;
            private final String name;
            private final Class<?> type;

            Accessor(Class<?> implementationClass, Field field) {
                this.implementationClass = implementationClass;
                this.field = field;
                this.name = field.getName();
                this.type = ClassUtil.getActualTypeBinding(implementationClass, field.getDeclaringClass(), field.getGenericType());
            }

            @Override
            public AccessStyle getAccessStyle() {
                return FIELD;
            }

            public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
                return this.field.getAnnotation(annotationClass);
            }

            @Override
            public Annotation[] getAnnotations() {
                return this.field.getAnnotations();
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return this.field.getDeclaredAnnotations();
            }

            @Override
            public Class<?> getDeclaringClass() {
                return this.field.getDeclaringClass();
            }

            @Override
            public AnnotatedElement getElement() {
                return this.field;
            }

            @Override
            public Type getGenericType() {
                return this.field.getGenericType();
            }

            @Override
            public <E, T> T getValue(E entity) {
                if (entity == null) {
                    return null;
                }
                try {
                    if (!this.field.isAccessible()) {
                        this.field.setAccessible(true);
                    }
                    return (T)this.field.get(entity);
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public boolean isPersistent() {
                int modifiers = this.field.getModifiers();
                return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers) && !this.isAnnotationPresent(Transient.class) && !this.isAnnotationPresent(Formula.class);
            }

            @Override
            public <E, T> void setValue(E entity, T value) {
                try {
                    if (!this.field.isAccessible()) {
                        this.field.setAccessible(true);
                    }
                    this.field.set(entity, value);
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException(e);
                }
            }

            public String toString() {
                return this.field.toString();
            }

            @Override
            public Class<?> getImplementationClass() {
                return this.implementationClass;
            }

            public Field getField() {
                return this.field;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }
        }
    }
    ,
    METHOD{

        @Override
        public <E> Iterable<AttributeAccessor> getDeclaredAttributes(Class<E> inspectedClass, Class<? extends E> implementationClass) {
            ArrayList<AttributeAccessor> result = new ArrayList<AttributeAccessor>();
            Method[] methodArray = inspectedClass.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                Method method = methodArray[n2];
                if (!Modifier.isStatic(method.getModifiers()) && !method.isSynthetic() && method.getParameterCount() == 0 && ((name = method.getName()).startsWith("get") || name.startsWith("is"))) {
                    result.add(new Accessor(implementationClass, method));
                }
                ++n2;
            }
            return result;
        }

        final class Accessor
        implements AttributeAccessor {
            private final Class<?> implementationClass;
            private final Method method;
            private Method setter;
            private final String name;
            private final Class<?> type;

            Accessor(Class<?> implementationClass, Method getter) {
                this.implementationClass = implementationClass;
                this.method = getter;
                this.name = Introspector.decapitalize(getter.getName().replaceFirst("^(get|is)", ""));
                this.type = ClassUtil.getActualTypeBinding(implementationClass, getter.getDeclaringClass(), getter.getGenericReturnType());
            }

            @Override
            public AccessStyle getAccessStyle() {
                return METHOD;
            }

            public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
                return this.method.getAnnotation(annotationClass);
            }

            @Override
            public Annotation[] getAnnotations() {
                return this.method.getAnnotations();
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return this.method.getDeclaredAnnotations();
            }

            @Override
            public Class<?> getDeclaringClass() {
                return this.method.getDeclaringClass();
            }

            @Override
            public AnnotatedElement getElement() {
                return this.method;
            }

            @Override
            public Type getGenericType() {
                return this.method.getGenericReturnType();
            }

            @Override
            public <E, T> T getValue(E entity) {
                if (entity == null) {
                    return null;
                }
                try {
                    if (!this.method.isAccessible()) {
                        this.method.setAccessible(true);
                    }
                    return (T)this.method.invoke(entity, new Object[0]);
                }
                catch (IllegalArgumentException | ReflectiveOperationException e) {
                    throw new IllegalStateException("Could not execute " + this.method + " on " + entity + ": " + e, e);
                }
            }

            @Override
            public boolean isPersistent() {
                int modifiers = this.method.getModifiers();
                return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers) && !this.isAnnotationPresent(Transient.class) && !this.isAnnotationPresent(Formula.class);
            }

            @Override
            public <E, T> void setValue(E entity, T value) {
                try {
                    if (this.setter == null) {
                        String setterName = "set" + StringUtils.capitalize((String)this.name);
                        Class<?> paramType = this.method.getReturnType();
                        Method[] methodArray = this.method.getDeclaringClass().getDeclaredMethods();
                        int n = methodArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Class<?>[] parameterTypes;
                            Method m = methodArray[n2];
                            if (m.getName().equals(setterName) && (parameterTypes = m.getParameterTypes()).length == 1 && parameterTypes[0] == paramType) {
                                this.setter = m;
                                break;
                            }
                            ++n2;
                        }
                        if (this.setter == null) {
                            throw new ModelException("Can't find setter: " + this.method.getDeclaringClass() + '.' + setterName + '(' + paramType + ')');
                        }
                        if (!this.setter.isAccessible()) {
                            this.setter.setAccessible(true);
                        }
                    }
                    this.setter.invoke(entity, value);
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException(e);
                }
            }

            public String toString() {
                return this.method.toString();
            }

            @Override
            public Class<?> getImplementationClass() {
                return this.implementationClass;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }
        }
    };


    private AccessStyle() {
    }

    public static AccessStyle getStyle(AccessType type) {
        return type == AccessType.FIELD ? FIELD : METHOD;
    }

    public abstract <E> Iterable<AttributeAccessor> getDeclaredAttributes(Class<E> var1, Class<? extends E> var2);

    /* synthetic */ AccessStyle(String string, int n, AccessStyle accessStyle) {
        this();
    }
}

