/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.converter;

import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;

public class LobConverter
implements ValueConverter<Object> {
    @Override
    public ColumnExpression getExpression(Object value, GeneratorContext context) {
        if (value instanceof String) {
            return PrimitiveColumnExpression.create((String)value, context.getDialect());
        }
        if (value instanceof char[]) {
            return PrimitiveColumnExpression.create(new String((char[])value), context.getDialect());
        }
        if (value instanceof byte[]) {
            return new PrimitiveColumnExpression<byte[]>((byte[])value, context.getDialect()::createBlobExpression);
        }
        throw new IllegalArgumentException("Can't handle LOB of type " + value.getClass());
    }

    @Override
    public ColumnExpression getExpression(String defaultValue, GeneratorContext context) {
        return this.getExpression((Object)defaultValue, context);
    }
}

