/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.converter;

import javax.persistence.Column;
import javax.persistence.MapKeyColumn;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;

public class StringConverter
implements ValueConverter<String> {
    private static final int DEFAULT_COLUMN_LENGTH = 255;
    private final int maxSize;
    private final int minSize;
    private boolean nullable;
    private final String attributeName;

    public StringConverter() {
        this.minSize = 0;
        this.maxSize = Integer.MAX_VALUE;
        this.attributeName = "column";
        this.nullable = true;
    }

    public StringConverter(AttributeAccessor attribute, boolean mapKey) {
        this.attributeName = attribute.toString();
        if (mapKey) {
            MapKeyColumn column = attribute.getAnnotation(MapKeyColumn.class);
            this.nullable = column == null || column.nullable();
            this.maxSize = column != null ? column.length() : 255;
            this.minSize = 0;
        } else {
            Column column = attribute.getAnnotation(Column.class);
            int columnLength = column != null ? column.length() : 255;
            this.nullable = (column == null || column.nullable()) && !attribute.isAnnotationPresent(NotNull.class);
            Size size = attribute.getAnnotation(Size.class);
            if (size != null) {
                this.maxSize = size.max() < Integer.MAX_VALUE ? size.max() : columnLength;
                this.minSize = size.min();
            } else {
                this.maxSize = columnLength;
                this.minSize = 0;
            }
        }
    }

    public StringConverter(Column column, boolean nullable) {
        this.attributeName = column == null || column.name().length() == 0 ? "column" : column.name();
        this.minSize = 0;
        this.maxSize = column != null ? column.length() : 255;
        this.nullable = nullable && (column == null || column.nullable());
    }

    @Override
    public ColumnExpression getExpression(String value, GeneratorContext context) {
        if (value.length() > this.maxSize) {
            throw new IllegalArgumentException("The length of the given string value (" + value.length() + ") exceeds the maximum allowed length of " + this.attributeName + " (" + this.maxSize + "): " + value);
        }
        if (value.length() < this.minSize) {
            throw new IllegalArgumentException("The length of the given string value (" + value.length() + ") is smaller than the minimum allowed length of " + this.attributeName + " (" + this.minSize + "): " + value);
        }
        if (value.length() == 0 && !this.nullable && context.getDialect().isEmptyStringEqualToNull()) {
            throw new IllegalArgumentException("The given string is empty, but property " + this.attributeName + " must be not empty for the current database type.");
        }
        return PrimitiveColumnExpression.create(value, context.getDialect());
    }
}

