/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.persistence.AssociationOverride;
import javax.persistence.OrderColumn;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.PluralProperty;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.converter.EntityConverter;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;
import org.fastnate.generator.statements.StatementsWriter;

public class CollectionProperty<E, T>
extends PluralProperty<E, Collection<T>, T> {
    private final GeneratorColumn orderColumn;

    static boolean isCollectionProperty(AttributeAccessor attribute) {
        return Collection.class.isAssignableFrom(attribute.getType()) && CollectionProperty.hasPluralAnnotation(attribute);
    }

    public CollectionProperty(EntityClass<?> sourceClass, AttributeAccessor attribute, AssociationOverride override) {
        super(sourceClass, attribute, override, 0);
        OrderColumn orderColumnDef = attribute.getAnnotation(OrderColumn.class);
        this.orderColumn = orderColumnDef == null ? null : this.getTable().resolveColumn(orderColumnDef.name().length() == 0 ? String.valueOf(attribute.getName()) + "_ORDER" : orderColumnDef.name());
    }

    @Override
    public void createPostInsertStatements(StatementsWriter writer, E entity) throws IOException {
        if (this.getMappedBy() == null || this.orderColumn != null) {
            ColumnExpression sourceId = EntityConverter.getEntityReference(entity, this.getMappedId(), this.getContext(), false);
            int index = 0;
            GeneratorDialect dialect = this.getDialect();
            Object collection = this.getValue((Object)entity);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                this.createValueStatement(writer, entity, sourceId, PrimitiveColumnExpression.create(index++, dialect), value);
            }
        }
    }

    @Override
    public Collection<?> findReferencedEntities(E entity) {
        if (this.isEmbedded()) {
            ArrayList result = new ArrayList();
            Iterator iterator = this.getValue((Object)entity).iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                for (Property property : this.getEmbeddedProperties()) {
                    result.addAll(property.findReferencedEntities(value));
                }
            }
            return result;
        }
        if (this.isEntityReference()) {
            return this.getValue((Object)entity);
        }
        return Collections.emptySet();
    }

    @Override
    protected GeneratorColumn getKeyColumn() {
        return this.orderColumn;
    }

    @Override
    public Collection<T> getValue(E entity) {
        Collection value = (Collection)super.getValue(entity);
        return value == null ? Collections.emptySet() : value;
    }

    public GeneratorColumn getOrderColumn() {
        return this.orderColumn;
    }
}

