/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.statements;

import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.ColumnExpression;

public abstract class SequenceValueExpression
implements ColumnExpression {
    private final GeneratorDialect dialect;
    private final String sequenceName;
    private final int incrementSize;
    private final long difference;

    protected String toSql(String sql) {
        if (this.difference == 0L) {
            return sql;
        }
        return String.valueOf('(') + sql + " - " + this.difference + ')';
    }

    public GeneratorDialect getDialect() {
        return this.dialect;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public long getDifference() {
        return this.difference;
    }

    public SequenceValueExpression(GeneratorDialect dialect, String sequenceName, int incrementSize, long difference) {
        this.dialect = dialect;
        this.sequenceName = sequenceName;
        this.incrementSize = incrementSize;
        this.difference = difference;
    }
}

