/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.validation.constraints.NotNull;
import org.fastnate.generator.DefaultValue;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.context.SingularProperty;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;
import org.fastnate.generator.statements.TableStatement;

public class PrimitiveProperty<E, T>
extends SingularProperty<E, T> {
    private final GeneratorContext context;
    private final GeneratorTable table;
    private final GeneratorColumn column;
    private final boolean required;
    private final ValueConverter<T> converter;
    private final String defaultValue;

    private static boolean isRequired(AttributeAccessor attribute) {
        Basic basic = attribute.getAnnotation(Basic.class);
        return basic != null && !basic.optional() || attribute.isAnnotationPresent(NotNull.class) || attribute.getType().isPrimitive();
    }

    public PrimitiveProperty(GeneratorContext context, GeneratorTable table, AttributeAccessor attribute, Column columnMetadata) {
        this(context, table, attribute, columnMetadata, false);
    }

    public PrimitiveProperty(GeneratorContext context, GeneratorTable table, AttributeAccessor attribute, Column columnMetadata, boolean autogenerated) {
        super(attribute);
        this.context = context;
        this.table = table;
        this.column = table.resolveColumn(columnMetadata == null || columnMetadata.name().length() == 0 ? attribute.getName() : columnMetadata.name(), autogenerated);
        this.required = columnMetadata != null && !columnMetadata.nullable() || PrimitiveProperty.isRequired(attribute);
        this.converter = context.getProvider().createConverter(attribute, attribute.getType(), false);
        this.defaultValue = this.getDefaultValue(attribute);
    }

    @Override
    public void addInsertExpression(TableStatement statement, E entity) {
        Object value = this.getValue(entity);
        if (value != null) {
            statement.setColumnValue(this.getColumn(), this.converter.getExpression(value, this.context));
        } else if (this.defaultValue != null) {
            statement.setColumnValue(this.getColumn(), this.converter.getExpression(this.defaultValue, this.context));
        } else {
            this.failIfRequired(entity);
            if (this.context.isWriteNullValues()) {
                statement.setColumnValue(this.column, PrimitiveColumnExpression.NULL);
            }
        }
    }

    protected String getDefaultValue(AttributeAccessor attribute) {
        DefaultValue defaultValueAnnotation = attribute.getAnnotation(DefaultValue.class);
        if (defaultValueAnnotation != null) {
            return defaultValueAnnotation.value();
        }
        return null;
    }

    protected GeneratorDialect getDialect() {
        return this.getContext().getDialect();
    }

    @Override
    public ColumnExpression getExpression(E entity, boolean whereExpression) {
        Object value = this.getValue(entity);
        if (value == null) {
            if (this.defaultValue != null) {
                return this.converter.getExpression(this.defaultValue, this.context);
            }
            return PrimitiveColumnExpression.NULL;
        }
        return this.converter.getExpression(value, this.context);
    }

    @Override
    public String getPredicate(E entity) {
        Object value = this.getValue(entity);
        if (value == null) {
            return this.column + " IS NULL";
        }
        return this.column + " = " + this.converter.getExpression(value, this.context);
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    public GeneratorTable getTable() {
        return this.table;
    }

    @Override
    public GeneratorColumn getColumn() {
        return this.column;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public ValueConverter<T> getConverter() {
        return this.converter;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

