/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.IOException;
import javax.persistence.SequenceGenerator;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.context.IdGenerator;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.CurrentSequenceValueExpression;
import org.fastnate.generator.statements.NextSequenceValueExpression;
import org.fastnate.generator.statements.PlainColumnExpression;
import org.fastnate.generator.statements.SequenceValueExpression;
import org.fastnate.generator.statements.StatementsWriter;
import org.fastnate.generator.statements.TableStatement;

public class SequenceIdGenerator
extends IdGenerator {
    private final GeneratorDialect dialect;
    private final String catalog;
    private final String schema;
    private final String sequenceName;
    private final String qualifiedName;
    private final boolean relativeIds;
    private final int allocationSize;
    private long initialValue;
    private long nextValue;
    private long currentSequenceValue;

    public SequenceIdGenerator(SequenceGenerator generator, GeneratorDialect dialect, boolean relativeIds) {
        this.dialect = dialect;
        this.catalog = generator.catalog().length() == 0 ? null : generator.catalog();
        this.schema = generator.schema().length() == 0 ? null : generator.schema();
        this.sequenceName = generator.sequenceName();
        if (this.catalog == null) {
            this.qualifiedName = this.schema == null ? this.sequenceName : String.valueOf(this.schema) + '.' + this.sequenceName;
        } else {
            ModelException.test(this.schema != null, "Catalog name '{}' found for sequence '{}' but schema name is missing.", this.catalog, this.sequenceName);
            this.qualifiedName = String.valueOf(this.catalog) + '.' + this.schema + '.' + this.sequenceName;
        }
        this.relativeIds = relativeIds;
        this.allocationSize = generator.allocationSize();
        this.nextValue = this.initialValue = (long)generator.initialValue();
        this.currentSequenceValue = this.initialValue - 1L;
    }

    @Override
    public void addNextValue(TableStatement statement, GeneratorColumn column, Number value) {
        SequenceValueExpression expression;
        if (this.dialect.isNextSequenceValueInInsertSupported() && this.currentSequenceValue <= value.longValue()) {
            this.currentSequenceValue = this.currentSequenceValue < this.initialValue ? this.initialValue : (this.currentSequenceValue += (long)this.allocationSize);
            expression = new NextSequenceValueExpression(this, this.currentSequenceValue - value.longValue());
        } else {
            expression = new CurrentSequenceValueExpression(this, this.currentSequenceValue - value.longValue());
        }
        statement.setColumnValue(column, expression);
    }

    @Override
    public void alignNextValue(StatementsWriter writer) throws IOException {
        if (!(this.relativeIds || this.nextValue <= this.initialValue || this.currentSequenceValue < this.nextValue && this.currentSequenceValue >= this.initialValue)) {
            long currentValue = this.currentSequenceValue;
            this.currentSequenceValue = this.nextValue - 1L;
            this.dialect.adjustNextSequenceValue(writer, this.qualifiedName, currentValue, this.currentSequenceValue + (long)this.allocationSize, this.allocationSize);
        }
    }

    @Override
    public long createNextValue() {
        return this.nextValue++;
    }

    @Override
    public void createPreInsertStatements(StatementsWriter writer) throws IOException {
        if (!this.dialect.isNextSequenceValueInInsertSupported() && this.currentSequenceValue <= this.nextValue) {
            this.currentSequenceValue = this.currentSequenceValue < this.initialValue ? this.initialValue : (this.currentSequenceValue += (long)this.allocationSize);
            writer.writePlainStatement(this.dialect, this.dialect.buildNextSequenceValue(this.qualifiedName, this.allocationSize));
        }
    }

    @Override
    public long getCurrentValue() {
        return this.nextValue - 1L;
    }

    @Override
    public ColumnExpression getExpression(GeneratorTable entityTable, GeneratorColumn column, Number targetId, boolean whereExpression) {
        if (!whereExpression || this.dialect.isSequenceInWhereSupported()) {
            return new CurrentSequenceValueExpression(this, this.currentSequenceValue - targetId.longValue());
        }
        long diff = this.nextValue - 1L - targetId.longValue();
        return new PlainColumnExpression("(SELECT max(" + column.getName() + ')' + (diff == 0L ? "" : " - " + diff) + " FROM " + entityTable.getQualifiedName() + ')');
    }

    @Override
    public boolean isPostIncrement() {
        return false;
    }

    @Override
    public void setCurrentValue(long currentValue) {
        this.nextValue = this.initialValue = currentValue + 1L;
        this.currentSequenceValue = currentValue;
    }

    public GeneratorDialect getDialect() {
        return this.dialect;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public boolean isRelativeIds() {
        return this.relativeIds;
    }

    public int getAllocationSize() {
        return this.allocationSize;
    }

    public long getInitialValue() {
        return this.initialValue;
    }
}

