/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.converter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;

public class NumberConverter
implements ValueConverter<Number> {
    private Constructor<? extends Number> stringConstructor;

    public NumberConverter(Class<? extends Number> type) {
        try {
            this.stringConstructor = type.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new ModelException("Missing String constructor in " + type, e);
        }
    }

    @Override
    public ColumnExpression getExpression(Number value, GeneratorContext context) {
        return PrimitiveColumnExpression.create(value, context.getDialect());
    }

    @Override
    public ColumnExpression getExpression(String defaultValue, GeneratorContext context) {
        try {
            return PrimitiveColumnExpression.create(this.stringConstructor.newInstance(defaultValue), context.getDialect());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Can't convert default value '" + defaultValue + "' to " + this.stringConstructor.getDeclaringClass(), e);
        }
    }
}

