/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.dialect;

import java.util.Date;
import javax.persistence.TemporalType;
import org.fastnate.generator.RelativeDate;
import org.fastnate.generator.dialect.GeneratorDialect;

public class MsSqlDialect
extends GeneratorDialect {
    @Override
    protected void addQuotedCharacter(StringBuilder result, char c) {
        result.append("CHAR(").append((byte)c).append(')');
    }

    @Override
    public String buildCurrentSequenceValue(String sequence, int incrementSize) {
        if (this.isEmulatingSequences()) {
            return super.buildCurrentSequenceValue(sequence, incrementSize);
        }
        return "(SELECT current_value FROM sys.sequences WHERE name = '" + sequence + "')";
    }

    @Override
    public String buildNextSequenceValue(String sequence, int incrementSize) {
        if (this.isEmulatingSequences()) {
            return super.buildNextSequenceValue(sequence, incrementSize);
        }
        return "NEXT VALUE FOR " + sequence;
    }

    @Override
    protected String convertTemporalValue(Date value) {
        return super.convertTemporalValue(value).replace("-", "");
    }

    @Override
    public String convertTemporalValue(Date value, TemporalType type) {
        if (value == RelativeDate.TODAY) {
            return "CAST(GETDATE() AS DATE)";
        }
        return super.convertTemporalValue(value, type);
    }

    @Override
    public String createBlobExpression(byte[] blob) {
        return this.createHexBlobExpression("0x", blob, "");
    }

    @Override
    public String getConcatOperator() {
        return " + ";
    }

    @Override
    public boolean isEmulatingSequences() {
        return true;
    }

    @Override
    public boolean isSettingIdentityAllowed() {
        return false;
    }
}

