/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.dialect;

import java.io.IOException;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.dialect.GeneratorDialect;
import org.fastnate.generator.statements.StatementsWriter;

public class PostgresDialect
extends GeneratorDialect {
    @Override
    protected void addQuotedCharacter(StringBuilder result, char c) {
        if (c == '\u0000') {
            throw new IllegalArgumentException("PostgreSQL does not support '\\0' characters");
        }
        super.addQuotedCharacter(result, c);
    }

    @Override
    public void adjustNextIdentityValue(StatementsWriter writer, GeneratorTable table, GeneratorColumn columnName, long nextValue) throws IOException {
        writer.writePlainStatement(this, "ALTER SEQUENCE " + table.getQualifiedName() + "_id_seq RESTART WITH " + nextValue);
    }

    @Override
    public String convertBooleanValue(boolean value) {
        return value ? "true" : "false";
    }

    @Override
    protected String createAddDateExpression(String referenceDate, long value, String unit) {
        return String.valueOf(referenceDate) + ' ' + (value < 0L ? (char)'-' : '+') + " INTERVAL '" + Math.abs(value) + ' ' + unit + '\'';
    }

    @Override
    public String createBlobExpression(byte[] blob) {
        return this.createHexBlobExpression("decode('", blob, "', 'hex')");
    }

    @Override
    public void truncateTable(StatementsWriter writer, GeneratorTable table) throws IOException {
        writer.writePlainStatement(this, "TRUNCATE TABLE " + table.getQualifiedName() + " CASCADE");
    }
}

