/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.provider;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import javax.persistence.AttributeConverter;
import javax.persistence.Convert;
import javax.persistence.Lob;
import javax.persistence.TemporalType;
import org.apache.commons.lang.ClassUtils;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.converter.BooleanConverter;
import org.fastnate.generator.converter.CalendarConverter;
import org.fastnate.generator.converter.CharConverter;
import org.fastnate.generator.converter.CustomValueConverter;
import org.fastnate.generator.converter.DateConverter;
import org.fastnate.generator.converter.EnumConverter;
import org.fastnate.generator.converter.LobConverter;
import org.fastnate.generator.converter.NumberConverter;
import org.fastnate.generator.converter.SerializableConverter;
import org.fastnate.generator.converter.StringConverter;
import org.fastnate.generator.converter.UnsupportedTypeConverter;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.util.ClassUtil;

public interface JpaProvider {
    default public <T> ValueConverter<T> createBasicConverter(String attributeName, Class<T> targetType) {
        if (String.class == targetType) {
            return new StringConverter();
        }
        if (byte[].class == targetType || char[].class == targetType) {
            return new LobConverter();
        }
        if (Date.class.isAssignableFrom(targetType)) {
            return new DateConverter(TemporalType.TIMESTAMP);
        }
        if (Calendar.class.isAssignableFrom(targetType)) {
            return new CalendarConverter(TemporalType.TIMESTAMP);
        }
        Class type = ClassUtils.primitiveToWrapper(targetType);
        if (Character.class == type) {
            return new CharConverter();
        }
        if (Boolean.class == type) {
            return new BooleanConverter();
        }
        if (Number.class.isAssignableFrom(type)) {
            return new NumberConverter(type);
        }
        return this.createFallbackConverter(attributeName, type);
    }

    default public <T> ValueConverter<T> createConverter(AttributeAccessor attribute, Class<T> targetType, boolean mapKey) {
        Convert convert = attribute.getAnnotation(Convert.class);
        if (convert != null && !convert.disableConversion()) {
            Class converterClass = convert.converter();
            Class databaseType = ClassUtil.getActualTypeBinding(converterClass, AttributeConverter.class, 1);
            try {
                return new CustomValueConverter((AttributeConverter)converterClass.newInstance(), this.createBasicConverter(attribute.getName(), databaseType));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Could not create AttributeConverter: " + converterClass, e);
            }
        }
        if (attribute.isAnnotationPresent(Lob.class)) {
            return new LobConverter();
        }
        if (Date.class.isAssignableFrom(targetType)) {
            return new DateConverter(attribute, mapKey);
        }
        if (Calendar.class.isAssignableFrom(targetType)) {
            return new CalendarConverter(attribute, mapKey);
        }
        if (Enum.class.isAssignableFrom(targetType)) {
            Class<T> enumClass = targetType;
            return new EnumConverter<T>(attribute, enumClass, mapKey);
        }
        return this.createBasicConverter(attribute.getName(), targetType);
    }

    default public <T> ValueConverter<T> createFallbackConverter(String attributeName, Class<T> targetType) {
        if (Serializable.class.isAssignableFrom(targetType)) {
            return new SerializableConverter();
        }
        return new UnsupportedTypeConverter(attributeName);
    }

    public String getDefaultGeneratorTable();

    public String getDefaultGeneratorTablePkColumnName();

    public String getDefaultGeneratorTablePkColumnValue();

    public String getDefaultGeneratorTableValueColumnName();

    public String getDefaultSequence();

    public void initialize(Properties var1);

    public boolean isJoinedDiscriminatorNeeded();
}

