/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.context;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.persistence.AssociationOverride;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.validation.constraints.NotNull;
import org.fastnate.generator.context.AnyMapping;
import org.fastnate.generator.context.AttributeAccessor;
import org.fastnate.generator.context.EntityClass;
import org.fastnate.generator.context.GeneratorColumn;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.context.GeneratorTable;
import org.fastnate.generator.context.ModelException;
import org.fastnate.generator.context.Property;
import org.fastnate.generator.context.SingularProperty;
import org.fastnate.generator.converter.EntityConverter;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;
import org.fastnate.generator.statements.StatementsWriter;
import org.fastnate.generator.statements.TableStatement;
import org.hibernate.annotations.Any;

public class EntityProperty<E, T>
extends SingularProperty<E, T> {
    private final GeneratorContext context;
    private final EntityClass<T> targetClass;
    private final boolean required;
    private final boolean composition;
    private final String mappedBy;
    private Property<T, ?> inverseProperty;
    private final GeneratorColumn column;
    private final String idField;
    private final AnyMapping<T> anyMapping;

    static boolean isEntityProperty(AttributeAccessor attribute) {
        return attribute.isAnnotationPresent(OneToOne.class) || attribute.isAnnotationPresent(ManyToOne.class) || attribute.isAnnotationPresent(Any.class);
    }

    public EntityProperty(GeneratorContext context, GeneratorTable containerTable, AttributeAccessor attribute, @Nullable AssociationOverride override) {
        super(attribute);
        this.context = context;
        MappingInformation mapping = new MappingInformation(attribute);
        Class<?> type = mapping.getValueClass();
        this.targetClass = context.getDescription(type);
        this.required = !mapping.isOptional();
        this.composition = mapping.isComposition();
        this.mappedBy = mapping.getMappedBy().length() == 0 ? null : mapping.getMappedBy();
        MapsId mapsId = attribute.getAnnotation(MapsId.class);
        String string = this.idField = mapsId != null ? mapsId.value() : null;
        if (this.mappedBy == null) {
            JoinColumn joinColumn;
            JoinColumn joinColumn2 = joinColumn = override != null && override.joinColumns().length > 0 ? override.joinColumns()[0] : attribute.getAnnotation(JoinColumn.class);
            this.column = joinColumn != null && joinColumn.name().length() > 0 ? containerTable.resolveColumn(joinColumn.name()) : containerTable.resolveColumn(String.valueOf(attribute.getName()) + "_" + (this.targetClass == null ? "id" : this.targetClass.getIdColumn(attribute)));
        } else {
            this.column = null;
            this.targetClass.onPropertiesAvailable(entityClass -> {
                EntityProperty entityProperty;
                Property mappedByProperty = entityClass.getProperties().get(this.mappedBy);
                if (!(mappedByProperty instanceof EntityProperty)) {
                    throw new ModelException("Unsupported \"mapped by\" property for " + this.getAttribute());
                }
                this.inverseProperty = entityProperty = (EntityProperty)mappedByProperty;
                entityProperty.inverseProperty = this;
            });
        }
        this.anyMapping = mapping.buildAnyMapping(context, containerTable);
    }

    @Override
    public void addInsertExpression(TableStatement statement, E entity) {
        if (this.column != null) {
            Object value = this.getValue(entity);
            if (value != null) {
                ColumnExpression expression;
                EntityClass entityClass;
                if (this.anyMapping != null) {
                    this.anyMapping.setColumnValue(statement, value);
                }
                if (!(entityClass = this.context.getDescription(value)).isNew(value) && (expression = entityClass.getEntityReference(value, this.idField, false)) != null) {
                    statement.setColumnValue(this.column, expression);
                    return;
                }
                entityClass.markPendingUpdates(value, entity, this, new Object[0]);
            }
            this.failIfRequired(entity);
            if (this.context.isWriteNullValues()) {
                statement.setColumnValue(this.column, PrimitiveColumnExpression.NULL);
                if (this.anyMapping != null && value == null) {
                    this.anyMapping.setColumnValue(statement, value);
                }
            }
        }
    }

    @Override
    public Collection<?> findReferencedEntities(E entity) {
        Object value = this.getValue(entity);
        return value == null ? Collections.emptySet() : Collections.singleton(value);
    }

    @Override
    public void generatePendingStatements(StatementsWriter writer, E entity, Object writtenEntity, Object ... arguments) throws IOException {
        ColumnExpression expression = this.context.getDescription(writtenEntity).getEntityReference(writtenEntity, this.idField, false);
        ModelException.mustExist(expression, "Entity can't be referenced: {}", writtenEntity);
        EntityClass<E> entityClass = this.context.getDescription(entity);
        TableStatement stmt = writer.createUpdateStatement(this.context.getDialect(), entityClass.getTable(), entityClass.getIdColumn(this.getAttribute()), entityClass.getEntityReference(entity, this.idField, true));
        stmt.setColumnValue(this.column, expression);
        writer.writeStatement(stmt);
    }

    @Override
    public ColumnExpression getExpression(E entity, boolean whereExpression) {
        Object value = this.getValue(entity);
        if (value == null) {
            return PrimitiveColumnExpression.NULL;
        }
        return EntityConverter.getEntityReference(value, this.idField, this.context, whereExpression);
    }

    @Override
    public String getPredicate(E entity) {
        Object value = this.getValue(entity);
        if (value == null) {
            return String.valueOf(this.column.getName()) + " IS NULL";
        }
        ColumnExpression reference = EntityConverter.getEntityReference(value, this.idField, this.context, true);
        if (reference == null) {
            return null;
        }
        String predicate = this.column + " = " + reference.toSql();
        if (this.anyMapping == null) {
            return predicate;
        }
        return String.valueOf('(') + predicate + " AND " + this.anyMapping.getPredicate(value) + ')';
    }

    @Override
    public boolean isTableColumn() {
        return this.mappedBy == null;
    }

    void setInverseProperty(Property<T, ?> inverseProperty) {
        this.inverseProperty = inverseProperty;
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    public EntityClass<T> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public boolean isComposition() {
        return this.composition;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public Property<T, ?> getInverseProperty() {
        return this.inverseProperty;
    }

    @Override
    public GeneratorColumn getColumn() {
        return this.column;
    }

    public String getIdField() {
        return this.idField;
    }

    public AnyMapping<T> getAnyMapping() {
        return this.anyMapping;
    }

    private static class MappingInformation {
        private final AttributeAccessor attribute;
        private final Class<?> valueClass;
        private final boolean optional;
        private final String mappedBy;
        private final Column anyColumn;
        private final String anyDefName;
        private final boolean composition;

        MappingInformation(AttributeAccessor attribute) {
            this.attribute = attribute;
            OneToOne oneToOne = attribute.getAnnotation(OneToOne.class);
            NotNull notNull = attribute.getAnnotation(NotNull.class);
            if (oneToOne != null) {
                this.valueClass = oneToOne.targetEntity() == Void.TYPE ? attribute.getType() : oneToOne.targetEntity();
                this.optional = oneToOne.optional() && notNull == null;
                this.mappedBy = oneToOne.mappedBy();
                this.anyColumn = null;
                this.anyDefName = null;
                this.composition = Property.isComposition(oneToOne.cascade());
            } else {
                this.mappedBy = "";
                ManyToOne manyToOne = attribute.getAnnotation(ManyToOne.class);
                if (manyToOne != null) {
                    this.valueClass = manyToOne.targetEntity() == Void.TYPE ? attribute.getType() : manyToOne.targetEntity();
                    this.optional = manyToOne.optional() && notNull == null;
                    this.anyColumn = null;
                    this.anyDefName = null;
                    this.composition = Property.isComposition(manyToOne.cascade());
                } else {
                    Any any = attribute.getAnnotation(Any.class);
                    ModelException.mustExist(any, "{} declares none of OneToOne, ManyToOne, or Any", attribute);
                    this.valueClass = attribute.getType();
                    this.optional = any.optional() && notNull == null;
                    this.anyColumn = any.metaColumn();
                    this.anyDefName = any.metaDef();
                    this.composition = false;
                }
            }
        }

        <T> AnyMapping<T> buildAnyMapping(GeneratorContext context, GeneratorTable containerTable) {
            if (this.anyColumn == null) {
                return null;
            }
            return new AnyMapping(context, this.attribute, containerTable, this.anyColumn, this.anyDefName);
        }

        public AttributeAccessor getAttribute() {
            return this.attribute;
        }

        public Class<?> getValueClass() {
            return this.valueClass;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String getMappedBy() {
            return this.mappedBy;
        }

        public Column getAnyColumn() {
            return this.anyColumn;
        }

        public String getAnyDefName() {
            return this.anyDefName;
        }

        public boolean isComposition() {
            return this.composition;
        }
    }
}

