/*
 * Decompiled with CFR 0.152.
 */
package org.fastnate.generator.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.fastnate.generator.context.GeneratorContext;
import org.fastnate.generator.converter.ValueConverter;
import org.fastnate.generator.statements.ColumnExpression;
import org.fastnate.generator.statements.PrimitiveColumnExpression;

public class SerializableConverter
implements ValueConverter<Serializable> {
    private static final int DEFAULT_BUFFER_SIZE = 512;

    @Override
    public ColumnExpression getExpression(Serializable value, GeneratorContext context) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(512);
            Throwable throwable = null;
            Object var5_7 = null;
            try (ObjectOutputStream stream = new ObjectOutputStream(buffer);){
                stream.writeObject(value);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return new PrimitiveColumnExpression<byte[]>(buffer.toByteArray(), context.getDialect()::createBlobExpression);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

